<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalContent StructType
 * Meta information extracted from the WSDL
 * - documentation: This is intended to be used in conjunction with the ContentGroupCode attribute to provide additional information about the code being referenced. | Describes the specific content requested.
 * @subpackage Structs
 */
class AdditionalContent extends AbstractStructBase
{
    /**
     * The ContentGroupCode
     * Meta information extracted from the WSDL
     * - documentation: When used, the response message will be filtered to return only the content that was requested. Refer to OpenTravel code list Information Type (INF).
     * - use: required
     * @var string
     */
    public $ContentGroupCode;
    /**
     * Constructor method for AdditionalContent
     * @uses AdditionalContent::setContentGroupCode()
     * @param string $contentGroupCode
     */
    public function __construct($contentGroupCode = null)
    {
        $this
            ->setContentGroupCode($contentGroupCode);
    }
    /**
     * Get ContentGroupCode value
     * @return string
     */
    public function getContentGroupCode()
    {
        return $this->ContentGroupCode;
    }
    /**
     * Set ContentGroupCode value
     * @param string $contentGroupCode
     * @return \StructType\AdditionalContent
     */
    public function setContentGroupCode($contentGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($contentGroupCode) && !is_string($contentGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentGroupCode, true), gettype($contentGroupCode)), __LINE__);
        }
        $this->ContentGroupCode = $contentGroupCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
