<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccommodationServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Types of accommodations and services available for passenger purchase on a train.
 * @subpackage Structs
 */
class AccommodationServiceType extends AbstractStructBase
{
    /**
     * The AccommodationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccommodationDetail
     */
    public $AccommodationDetail;
    /**
     * The AncillaryService
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * - ref: AncillaryService
     * @var \StructType\AncillaryService[]
     */
    public $AncillaryService;
    /**
     * Constructor method for AccommodationServiceType
     * @uses AccommodationServiceType::setAccommodationDetail()
     * @uses AccommodationServiceType::setAncillaryService()
     * @param \StructType\AccommodationDetail $accommodationDetail
     * @param \StructType\AncillaryService[] $ancillaryService
     */
    public function __construct(\StructType\AccommodationDetail $accommodationDetail = null, array $ancillaryService = array())
    {
        $this
            ->setAccommodationDetail($accommodationDetail)
            ->setAncillaryService($ancillaryService);
    }
    /**
     * Get AccommodationDetail value
     * @return \StructType\AccommodationDetail|null
     */
    public function getAccommodationDetail()
    {
        return $this->AccommodationDetail;
    }
    /**
     * Set AccommodationDetail value
     * @param \StructType\AccommodationDetail $accommodationDetail
     * @return \StructType\AccommodationServiceType
     */
    public function setAccommodationDetail(\StructType\AccommodationDetail $accommodationDetail = null)
    {
        $this->AccommodationDetail = $accommodationDetail;
        return $this;
    }
    /**
     * Get AncillaryService value
     * @return \StructType\AncillaryService[]|null
     */
    public function getAncillaryService()
    {
        return $this->AncillaryService;
    }
    /**
     * This method is responsible for validating the values passed to the setAncillaryService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAncillaryService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAncillaryServiceForArrayConstraintsFromSetAncillaryService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accommodationServiceTypeAncillaryServiceItem) {
            // validation for constraint: itemType
            if (!$accommodationServiceTypeAncillaryServiceItem instanceof \StructType\AncillaryService) {
                $invalidValues[] = is_object($accommodationServiceTypeAncillaryServiceItem) ? get_class($accommodationServiceTypeAncillaryServiceItem) : sprintf('%s(%s)', gettype($accommodationServiceTypeAncillaryServiceItem), var_export($accommodationServiceTypeAncillaryServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AncillaryService property can only contain items of type \StructType\AncillaryService, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AncillaryService value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryService[] $ancillaryService
     * @return \StructType\AccommodationServiceType
     */
    public function setAncillaryService(array $ancillaryService = array())
    {
        // validation for constraint: array
        if ('' !== ($ancillaryServiceArrayErrorMessage = self::validateAncillaryServiceForArrayConstraintsFromSetAncillaryService($ancillaryService))) {
            throw new \InvalidArgumentException($ancillaryServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ancillaryService) && count($ancillaryService) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ancillaryService)), __LINE__);
        }
        $this->AncillaryService = $ancillaryService;
        return $this;
    }
    /**
     * Add item to AncillaryService value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryService $item
     * @return \StructType\AccommodationServiceType
     */
    public function addToAncillaryService(\StructType\AncillaryService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AncillaryService) {
            throw new \InvalidArgumentException(sprintf('The AncillaryService property can only contain items of type \StructType\AncillaryService, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AncillaryService) && count($this->AncillaryService) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AncillaryService)), __LINE__);
        }
        $this->AncillaryService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccommodationServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
