<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accommodation StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the parent of the Resort. The geo-political position of the destination (e.g. country) is determined by the DestinationLevel attribute. | Defines an accommodation component of a package holiday. | Type of accommodation,
 * including classes of seat, berth and compartment on a train that's occupied by a rail passenger.
 * @subpackage Structs
 */
class Accommodation extends AccommodationType
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Quantity for the accommodation.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The Identity
     * Meta information extracted from the WSDL
     * - documentation: Full name or description plus codes for a property.
     * - minOccurs: 0
     * @var mixed
     */
    public $Identity;
    /**
     * The AccommodationClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccommodationClass
     */
    public $AccommodationClass;
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - documentation: The Start date and Duration or End Date of the accommodation stay.
     * @var mixed
     */
    public $DateRange;
    /**
     * The RoomProfiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomProfiles
     */
    public $RoomProfiles;
    /**
     * The MealPlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealPlans
     */
    public $MealPlans;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ResortName
     * Meta information extracted from the WSDL
     * - documentation: Describes the resort or area containing a property.
     * - use: optional
     * @var string
     */
    public $ResortName;
    /**
     * The ResortCode
     * Meta information extracted from the WSDL
     * - documentation: The code for the resort or area containing a property.
     * - use: optional
     * @var string
     */
    public $ResortCode;
    /**
     * Constructor method for Accommodation
     * @uses Accommodation::setQuantity()
     * @uses Accommodation::setIdentity()
     * @uses Accommodation::setAccommodationClass()
     * @uses Accommodation::setDateRange()
     * @uses Accommodation::setRoomProfiles()
     * @uses Accommodation::setMealPlans()
     * @uses Accommodation::setRPH()
     * @uses Accommodation::setResortName()
     * @uses Accommodation::setResortCode()
     * @param int $quantity
     * @param mixed $identity
     * @param \StructType\AccommodationClass $accommodationClass
     * @param mixed $dateRange
     * @param \StructType\RoomProfiles $roomProfiles
     * @param \StructType\MealPlans $mealPlans
     * @param string $rPH
     * @param string $resortName
     * @param string $resortCode
     */
    public function __construct($quantity = null, $identity = null, \StructType\AccommodationClass $accommodationClass = null, $dateRange = null, \StructType\RoomProfiles $roomProfiles = null, \StructType\MealPlans $mealPlans = null, $rPH = null, $resortName = null, $resortCode = null)
    {
        $this
            ->setQuantity($quantity)
            ->setIdentity($identity)
            ->setAccommodationClass($accommodationClass)
            ->setDateRange($dateRange)
            ->setRoomProfiles($roomProfiles)
            ->setMealPlans($mealPlans)
            ->setRPH($rPH)
            ->setResortName($resortName)
            ->setResortCode($resortCode);
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Accommodation
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Identity value
     * @return mixed|null
     */
    public function getIdentity()
    {
        return $this->Identity;
    }
    /**
     * Set Identity value
     * @param mixed $identity
     * @return \StructType\Accommodation
     */
    public function setIdentity($identity = null)
    {
        $this->Identity = $identity;
        return $this;
    }
    /**
     * Get AccommodationClass value
     * @return \StructType\AccommodationClass|null
     */
    public function getAccommodationClass()
    {
        return $this->AccommodationClass;
    }
    /**
     * Set AccommodationClass value
     * @param \StructType\AccommodationClass $accommodationClass
     * @return \StructType\Accommodation
     */
    public function setAccommodationClass(\StructType\AccommodationClass $accommodationClass = null)
    {
        $this->AccommodationClass = $accommodationClass;
        return $this;
    }
    /**
     * Get DateRange value
     * @return mixed|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param mixed $dateRange
     * @return \StructType\Accommodation
     */
    public function setDateRange($dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get RoomProfiles value
     * @return \StructType\RoomProfiles|null
     */
    public function getRoomProfiles()
    {
        return $this->RoomProfiles;
    }
    /**
     * Set RoomProfiles value
     * @param \StructType\RoomProfiles $roomProfiles
     * @return \StructType\Accommodation
     */
    public function setRoomProfiles(\StructType\RoomProfiles $roomProfiles = null)
    {
        $this->RoomProfiles = $roomProfiles;
        return $this;
    }
    /**
     * Get MealPlans value
     * @return \StructType\MealPlans|null
     */
    public function getMealPlans()
    {
        return $this->MealPlans;
    }
    /**
     * Set MealPlans value
     * @param \StructType\MealPlans $mealPlans
     * @return \StructType\Accommodation
     */
    public function setMealPlans(\StructType\MealPlans $mealPlans = null)
    {
        $this->MealPlans = $mealPlans;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Accommodation
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ResortName value
     * @return string|null
     */
    public function getResortName()
    {
        return $this->ResortName;
    }
    /**
     * Set ResortName value
     * @param string $resortName
     * @return \StructType\Accommodation
     */
    public function setResortName($resortName = null)
    {
        // validation for constraint: string
        if (!is_null($resortName) && !is_string($resortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resortName, true), gettype($resortName)), __LINE__);
        }
        $this->ResortName = $resortName;
        return $this;
    }
    /**
     * Get ResortCode value
     * @return string|null
     */
    public function getResortCode()
    {
        return $this->ResortCode;
    }
    /**
     * Set ResortCode value
     * @param string $resortCode
     * @return \StructType\Accommodation
     */
    public function setResortCode($resortCode = null)
    {
        // validation for constraint: string
        if (!is_null($resortCode) && !is_string($resortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resortCode, true), gettype($resortCode)), __LINE__);
        }
        $this->ResortCode = $resortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Accommodation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
