<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAN ServiceType
 * @subpackage Services
 */
class OTAN extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OTA_NotifReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_NotifReportRQ $notifReportRQ_msg
     * @return \StructType\MessageAcknowledgementType|bool
     */
    public function OTA_NotifReport(\StructType\OTA_NotifReportRQ $notifReportRQ_msg)
    {
        try {
            $this->setResult($this->getSoapClient()->OTA_NotifReport($notifReportRQ_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageAcknowledgementType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
