<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAH ServiceType
 * @subpackage Services
 */
class OTAH extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OTA_HotelRatePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelRatePlanRQ $hotelRatePlanRQ_msg
     * @return \StructType\OTA_HotelRatePlanRS|bool
     */
    public function OTA_HotelRatePlan(\StructType\OTA_HotelRatePlanRQ $hotelRatePlanRQ_msg)
    {
        try {
            $this->setResult($this->getSoapClient()->OTA_HotelRatePlan($hotelRatePlanRQ_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OTA_HotelAvailNotif
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelAvailNotifRQ $hotelAvailNotifRQ_msg
     * @return \StructType\MessageAcknowledgementType|bool
     */
    public function OTA_HotelAvailNotif(\StructType\OTA_HotelAvailNotifRQ $hotelAvailNotifRQ_msg)
    {
        try {
            $this->setResult($this->getSoapClient()->OTA_HotelAvailNotif($hotelAvailNotifRQ_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OTA_HotelRateAmountNotif
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelRateAmountNotifRQ $hotelRateAmountNotifRQ_msg
     * @return \StructType\MessageAcknowledgementType|bool
     */
    public function OTA_HotelRateAmountNotif(\StructType\OTA_HotelRateAmountNotifRQ $hotelRateAmountNotifRQ_msg)
    {
        try {
            $this->setResult($this->getSoapClient()->OTA_HotelRateAmountNotif($hotelRateAmountNotifRQ_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageAcknowledgementType|\StructType\OTA_HotelRatePlanRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
