<?php

namespace EnumType;

/**
 * This class stands for TrainPolicyCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: A train policy code.
 * @subpackage Enumerations
 */
class TrainPolicyCodeType
{
    /**
     * Constant for value 'Minimum'
     * @return string 'Minimum'
     */
    const VALUE_MINIMUM = 'Minimum';
    /**
     * Constant for value 'Maximum'
     * @return string 'Maximum'
     */
    const VALUE_MAXIMUM = 'Maximum';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MINIMUM
     * @uses self::VALUE_MAXIMUM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MINIMUM,
            self::VALUE_MAXIMUM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
