<?php

namespace EnumType;

/**
 * This class stands for TicketType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the type of ticket document (e.g. electronic, paper).
 * @subpackage Enumerations
 */
class TicketType
{
    /**
     * Constant for value 'eTicket'
     * Meta information extracted from the WSDL
     * - documentation: An electronic ticket
     * @return string 'eTicket'
     */
    const VALUE_E_TICKET = 'eTicket';
    /**
     * Constant for value 'Paper'
     * Meta information extracted from the WSDL
     * - documentation: A paper ticket
     * @return string 'Paper'
     */
    const VALUE_PAPER = 'Paper';
    /**
     * Constant for value 'MCO'
     * Meta information extracted from the WSDL
     * - documentation: A miscellaneous charge order
     * @return string 'MCO'
     */
    const VALUE_MCO = 'MCO';
    /**
     * Constant for value 'EMD-A'
     * @return string 'EMD-A'
     */
    const VALUE_EMD_A = 'EMD-A';
    /**
     * Constant for value 'EMD-S'
     * @return string 'EMD-S'
     */
    const VALUE_EMD_S = 'EMD-S';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_TICKET
     * @uses self::VALUE_PAPER
     * @uses self::VALUE_MCO
     * @uses self::VALUE_EMD_A
     * @uses self::VALUE_EMD_S
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_TICKET,
            self::VALUE_PAPER,
            self::VALUE_MCO,
            self::VALUE_EMD_A,
            self::VALUE_EMD_S,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
