<?php

namespace EnumType;

/**
 * This class stands for TaxType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Example: RoomExempt | Tax information for the entire group.
 * @subpackage Enumerations
 */
class TaxType
{
    /**
     * Constant for value 'Taxable'
     * @return string 'Taxable'
     */
    const VALUE_TAXABLE = 'Taxable';
    /**
     * Constant for value 'RoomExempt'
     * @return string 'RoomExempt'
     */
    const VALUE_ROOM_EXEMPT = 'RoomExempt';
    /**
     * Constant for value 'FullExempt'
     * @return string 'FullExempt'
     */
    const VALUE_FULL_EXEMPT = 'FullExempt';
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TAXABLE
     * @uses self::VALUE_ROOM_EXEMPT
     * @uses self::VALUE_FULL_EXEMPT
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TAXABLE,
            self::VALUE_ROOM_EXEMPT,
            self::VALUE_FULL_EXEMPT,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
