<?php

namespace EnumType;

/**
 * This class stands for StatusType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the status of the commission payment itself (e.g. no-show indicates that a different commission may be applied if the reservation is not fulfilled).
 * @subpackage Enumerations
 */
class StatusType
{
    /**
     * Constant for value 'Full'
     * @return string 'Full'
     */
    const VALUE_FULL = 'Full';
    /**
     * Constant for value 'Partial'
     * @return string 'Partial'
     */
    const VALUE_PARTIAL = 'Partial';
    /**
     * Constant for value 'Non-paying'
     * @return string 'Non-paying'
     */
    const VALUE_NON_PAYING = 'Non-paying';
    /**
     * Constant for value 'No-show'
     * @return string 'No-show'
     */
    const VALUE_NO_SHOW = 'No-show';
    /**
     * Constant for value 'Adjustment'
     * @return string 'Adjustment'
     */
    const VALUE_ADJUSTMENT = 'Adjustment';
    /**
     * Constant for value 'Commissionable'
     * @return string 'Commissionable'
     */
    const VALUE_COMMISSIONABLE = 'Commissionable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL
     * @uses self::VALUE_PARTIAL
     * @uses self::VALUE_NON_PAYING
     * @uses self::VALUE_NO_SHOW
     * @uses self::VALUE_ADJUSTMENT
     * @uses self::VALUE_COMMISSIONABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL,
            self::VALUE_PARTIAL,
            self::VALUE_NON_PAYING,
            self::VALUE_NO_SHOW,
            self::VALUE_ADJUSTMENT,
            self::VALUE_COMMISSIONABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
