<?php

namespace EnumType;

/**
 * This class stands for SourceType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Information describing the point of sale.
 * @subpackage Enumerations
 */
class SourceType
{
    /**
     * Constant for value 'NormalTransaction'
     * @return string 'NormalTransaction'
     */
    const VALUE_NORMAL_TRANSACTION = 'NormalTransaction';
    /**
     * Constant for value 'MailOrPhoneOrder'
     * @return string 'MailOrPhoneOrder'
     */
    const VALUE_MAIL_OR_PHONE_ORDER = 'MailOrPhoneOrder';
    /**
     * Constant for value 'UnattendedTerminal'
     * @return string 'UnattendedTerminal'
     */
    const VALUE_UNATTENDED_TERMINAL = 'UnattendedTerminal';
    /**
     * Constant for value 'MerchantIsSuspicious'
     * @return string 'MerchantIsSuspicious'
     */
    const VALUE_MERCHANT_IS_SUSPICIOUS = 'MerchantIsSuspicious';
    /**
     * Constant for value 'eCommerceSecuredTransaction'
     * @return string 'eCommerceSecuredTransaction'
     */
    const VALUE_E_COMMERCE_SECURED_TRANSACTION = 'eCommerceSecuredTransaction';
    /**
     * Constant for value 'eCommerceUnsecuredTransaction'
     * @return string 'eCommerceUnsecuredTransaction'
     */
    const VALUE_E_COMMERCE_UNSECURED_TRANSACTION = 'eCommerceUnsecuredTransaction';
    /**
     * Constant for value 'InFlightAirPhone'
     * @return string 'InFlightAirPhone'
     */
    const VALUE_IN_FLIGHT_AIR_PHONE = 'InFlightAirPhone';
    /**
     * Constant for value 'CID_NotLegible'
     * @return string 'CID_NotLegible'
     */
    const VALUE_CID_NOT_LEGIBLE = 'CID_NotLegible';
    /**
     * Constant for value 'CID_NotOnCard'
     * @return string 'CID_NotOnCard'
     */
    const VALUE_CID_NOT_ON_CARD = 'CID_NotOnCard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL_TRANSACTION
     * @uses self::VALUE_MAIL_OR_PHONE_ORDER
     * @uses self::VALUE_UNATTENDED_TERMINAL
     * @uses self::VALUE_MERCHANT_IS_SUSPICIOUS
     * @uses self::VALUE_E_COMMERCE_SECURED_TRANSACTION
     * @uses self::VALUE_E_COMMERCE_UNSECURED_TRANSACTION
     * @uses self::VALUE_IN_FLIGHT_AIR_PHONE
     * @uses self::VALUE_CID_NOT_LEGIBLE
     * @uses self::VALUE_CID_NOT_ON_CARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL_TRANSACTION,
            self::VALUE_MAIL_OR_PHONE_ORDER,
            self::VALUE_UNATTENDED_TERMINAL,
            self::VALUE_MERCHANT_IS_SUSPICIOUS,
            self::VALUE_E_COMMERCE_SECURED_TRANSACTION,
            self::VALUE_E_COMMERCE_UNSECURED_TRANSACTION,
            self::VALUE_IN_FLIGHT_AIR_PHONE,
            self::VALUE_CID_NOT_LEGIBLE,
            self::VALUE_CID_NOT_ON_CARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
