<?php

namespace EnumType;

/**
 * This class stands for SeatAccommodationType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the type of seat accommodation, such as lower level and upper level.
 * @subpackage Enumerations
 */
class SeatAccommodationType
{
    /**
     * Constant for value 'NotSignificant'
     * @return string 'NotSignificant'
     */
    const VALUE_NOT_SIGNIFICANT = 'NotSignificant';
    /**
     * Constant for value 'Seat'
     * @return string 'Seat'
     */
    const VALUE_SEAT = 'Seat';
    /**
     * Constant for value 'Sleeperette'
     * @return string 'Sleeperette'
     */
    const VALUE_SLEEPERETTE = 'Sleeperette';
    /**
     * Constant for value 'NoSeat'
     * @return string 'NoSeat'
     */
    const VALUE_NO_SEAT = 'NoSeat';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SIGNIFICANT
     * @uses self::VALUE_SEAT
     * @uses self::VALUE_SLEEPERETTE
     * @uses self::VALUE_NO_SEAT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SIGNIFICANT,
            self::VALUE_SEAT,
            self::VALUE_SLEEPERETTE,
            self::VALUE_NO_SEAT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
