<?php

namespace EnumType;

/**
 * This class stands for RatePlanEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies rate plan types.
 * @subpackage Enumerations
 */
class RatePlanEnum
{
    /**
     * Constant for value 'Government'
     * Meta information extracted from the WSDL
     * - documentation: Inventory is available for sale.
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Negotiated'
     * Meta information extracted from the WSDL
     * - documentation: Inventory is not available for sale.
     * @return string 'Negotiated'
     */
    const VALUE_NEGOTIATED = 'Negotiated';
    /**
     * Constant for value 'Preferred'
     * Meta information extracted from the WSDL
     * - documentation: Inventory is not available for sale to arriving guests.
     * @return string 'Preferred'
     */
    const VALUE_PREFERRED = 'Preferred';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Inventory may not be available for sale to arriving guests.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_NEGOTIATED
     * @uses self::VALUE_PREFERRED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GOVERNMENT,
            self::VALUE_NEGOTIATED,
            self::VALUE_PREFERRED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
