<?php

namespace EnumType;

/**
 * This class stands for RailPassengerOccupationEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specifiy occupation of person
 * @subpackage Enumerations
 */
class RailPassengerOccupationEnum
{
    /**
     * Constant for value 'NotSignificant'
     * @return string 'NotSignificant'
     */
    const VALUE_NOT_SIGNIFICANT = 'NotSignificant';
    /**
     * Constant for value 'RailEmployee'
     * @return string 'RailEmployee'
     */
    const VALUE_RAIL_EMPLOYEE = 'RailEmployee';
    /**
     * Constant for value 'GovernmentEmployee'
     * @return string 'GovernmentEmployee'
     */
    const VALUE_GOVERNMENT_EMPLOYEE = 'GovernmentEmployee';
    /**
     * Constant for value 'Farmer'
     * @return string 'Farmer'
     */
    const VALUE_FARMER = 'Farmer';
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'Journalist'
     * @return string 'Journalist'
     */
    const VALUE_JOURNALIST = 'Journalist';
    /**
     * Constant for value 'Student'
     * @return string 'Student'
     */
    const VALUE_STUDENT = 'Student';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SIGNIFICANT
     * @uses self::VALUE_RAIL_EMPLOYEE
     * @uses self::VALUE_GOVERNMENT_EMPLOYEE
     * @uses self::VALUE_FARMER
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_JOURNALIST
     * @uses self::VALUE_STUDENT
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SIGNIFICANT,
            self::VALUE_RAIL_EMPLOYEE,
            self::VALUE_GOVERNMENT_EMPLOYEE,
            self::VALUE_FARMER,
            self::VALUE_MILITARY,
            self::VALUE_JOURNALIST,
            self::VALUE_STUDENT,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
