<?php

namespace EnumType;

/**
 * This class stands for PaymentCardCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: This is intended to be used when the above enumeration list does not meet your needs. | The 2 digit code that identifies the credit card.
 * - union: UpperCaseAlphaLength1to2
 * @subpackage Enumerations
 */
class PaymentCardCodeType
{
    /**
     * Constant for value 'AX'
     * Meta information extracted from the WSDL
     * - documentation: American Express
     * @return string 'AX'
     */
    const VALUE_AX = 'AX';
    /**
     * Constant for value 'BC'
     * Meta information extracted from the WSDL
     * - documentation: Bank Card
     * @return string 'BC'
     */
    const VALUE_BC = 'BC';
    /**
     * Constant for value 'BL'
     * Meta information extracted from the WSDL
     * - documentation: Carte Bleu
     * @return string 'BL'
     */
    const VALUE_BL = 'BL';
    /**
     * Constant for value 'CB'
     * Meta information extracted from the WSDL
     * - documentation: Carte Blanche
     * @return string 'CB'
     */
    const VALUE_CB = 'CB';
    /**
     * Constant for value 'DN'
     * Meta information extracted from the WSDL
     * - documentation: Diners Club
     * @return string 'DN'
     */
    const VALUE_DN = 'DN';
    /**
     * Constant for value 'DS'
     * Meta information extracted from the WSDL
     * - documentation: Discover Card
     * @return string 'DS'
     */
    const VALUE_DS = 'DS';
    /**
     * Constant for value 'EC'
     * Meta information extracted from the WSDL
     * - documentation: Eurocard
     * @return string 'EC'
     */
    const VALUE_EC = 'EC';
    /**
     * Constant for value 'JC'
     * Meta information extracted from the WSDL
     * - documentation: Japanese Credit Bureau Credit Card
     * @return string 'JC'
     */
    const VALUE_JC = 'JC';
    /**
     * Constant for value 'MA'
     * Meta information extracted from the WSDL
     * - documentation: Maestro
     * @return string 'MA'
     */
    const VALUE_MA = 'MA';
    /**
     * Constant for value 'MC'
     * Meta information extracted from the WSDL
     * - documentation: Master Card
     * @return string 'MC'
     */
    const VALUE_MC = 'MC';
    /**
     * Constant for value 'TP'
     * Meta information extracted from the WSDL
     * - documentation: Universal Air Travel Card
     * @return string 'TP'
     */
    const VALUE_TP = 'TP';
    /**
     * Constant for value 'UP'
     * Meta information extracted from the WSDL
     * - documentation: China UnionPay
     * @return string 'UP'
     */
    const VALUE_UP = 'UP';
    /**
     * Constant for value 'VI'
     * Meta information extracted from the WSDL
     * - documentation: Visa
     * @return string 'VI'
     */
    const VALUE_VI = 'VI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AX
     * @uses self::VALUE_BC
     * @uses self::VALUE_BL
     * @uses self::VALUE_CB
     * @uses self::VALUE_DN
     * @uses self::VALUE_DS
     * @uses self::VALUE_EC
     * @uses self::VALUE_JC
     * @uses self::VALUE_MA
     * @uses self::VALUE_MC
     * @uses self::VALUE_TP
     * @uses self::VALUE_UP
     * @uses self::VALUE_VI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AX,
            self::VALUE_BC,
            self::VALUE_BL,
            self::VALUE_CB,
            self::VALUE_DN,
            self::VALUE_DS,
            self::VALUE_EC,
            self::VALUE_JC,
            self::VALUE_MA,
            self::VALUE_MC,
            self::VALUE_TP,
            self::VALUE_UP,
            self::VALUE_VI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
