<?php

namespace EnumType;

/**
 * This class stands for MealType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Airline meal types.
 * @subpackage Enumerations
 */
class MealType
{
    /**
     * Constant for value 'AVML'
     * Meta information extracted from the WSDL
     * - documentation: AVML - Asian Veg
     * @return string 'AVML'
     */
    const VALUE_AVML = 'AVML';
    /**
     * Constant for value 'BBML'
     * Meta information extracted from the WSDL
     * - documentation: BBML - Baby/Infant Food
     * @return string 'BBML'
     */
    const VALUE_BBML = 'BBML';
    /**
     * Constant for value 'BLML'
     * Meta information extracted from the WSDL
     * - documentation: BLML - Bland Meal
     * @return string 'BLML'
     */
    const VALUE_BLML = 'BLML';
    /**
     * Constant for value 'CHML'
     * Meta information extracted from the WSDL
     * - documentation: CHML - Child Meal
     * @return string 'CHML'
     */
    const VALUE_CHML = 'CHML';
    /**
     * Constant for value 'DBML'
     * Meta information extracted from the WSDL
     * - documentation: DBML - Diabetic
     * @return string 'DBML'
     */
    const VALUE_DBML = 'DBML';
    /**
     * Constant for value 'FPML'
     * Meta information extracted from the WSDL
     * - documentation: FPML - Fruit Meal
     * @return string 'FPML'
     */
    const VALUE_FPML = 'FPML';
    /**
     * Constant for value 'GFML'
     * Meta information extracted from the WSDL
     * - documentation: GFML - Gluten Free
     * @return string 'GFML'
     */
    const VALUE_GFML = 'GFML';
    /**
     * Constant for value 'HFML'
     * Meta information extracted from the WSDL
     * - documentation: HFML - High Fiber
     * @return string 'HFML'
     */
    const VALUE_HFML = 'HFML';
    /**
     * Constant for value 'HNML'
     * Meta information extracted from the WSDL
     * - documentation: HNML - Hindu Meal
     * @return string 'HNML'
     */
    const VALUE_HNML = 'HNML';
    /**
     * Constant for value 'KSML'
     * Meta information extracted from the WSDL
     * - documentation: KSML - Kosher
     * @return string 'KSML'
     */
    const VALUE_KSML = 'KSML';
    /**
     * Constant for value 'LCML'
     * Meta information extracted from the WSDL
     * - documentation: LCML - Low Calorie
     * @return string 'LCML'
     */
    const VALUE_LCML = 'LCML';
    /**
     * Constant for value 'LFML'
     * Meta information extracted from the WSDL
     * - documentation: LFML - Low Cholesterol
     * @return string 'LFML'
     */
    const VALUE_LFML = 'LFML';
    /**
     * Constant for value 'LPML'
     * Meta information extracted from the WSDL
     * - documentation: LPML - Low Protein
     * @return string 'LPML'
     */
    const VALUE_LPML = 'LPML';
    /**
     * Constant for value 'LSML'
     * Meta information extracted from the WSDL
     * - documentation: LSML - Low Sodium/No Salt
     * @return string 'LSML'
     */
    const VALUE_LSML = 'LSML';
    /**
     * Constant for value 'MOML'
     * Meta information extracted from the WSDL
     * - documentation: MOML - Moslem
     * @return string 'MOML'
     */
    const VALUE_MOML = 'MOML';
    /**
     * Constant for value 'NLML'
     * Meta information extracted from the WSDL
     * - documentation: NLML - Non-Lactose
     * @return string 'NLML'
     */
    const VALUE_NLML = 'NLML';
    /**
     * Constant for value 'ORML'
     * Meta information extracted from the WSDL
     * - documentation: ORML - Oriental
     * @return string 'ORML'
     */
    const VALUE_ORML = 'ORML';
    /**
     * Constant for value 'PRML'
     * Meta information extracted from the WSDL
     * - documentation: PRML - Low Purin
     * @return string 'PRML'
     */
    const VALUE_PRML = 'PRML';
    /**
     * Constant for value 'RVML'
     * Meta information extracted from the WSDL
     * - documentation: RVML - Raw Vegetarian
     * @return string 'RVML'
     */
    const VALUE_RVML = 'RVML';
    /**
     * Constant for value 'SFML'
     * Meta information extracted from the WSDL
     * - documentation: SFML - Seafood
     * @return string 'SFML'
     */
    const VALUE_SFML = 'SFML';
    /**
     * Constant for value 'SPML'
     * Meta information extracted from the WSDL
     * - documentation: SPML - Special/Specify
     * @return string 'SPML'
     */
    const VALUE_SPML = 'SPML';
    /**
     * Constant for value 'VGML'
     * Meta information extracted from the WSDL
     * - documentation: VGML - Vegetarian/Non Dairy
     * @return string 'VGML'
     */
    const VALUE_VGML = 'VGML';
    /**
     * Constant for value 'VLML'
     * Meta information extracted from the WSDL
     * - documentation: VLML - Vegetarian/Milk/Eggs
     * @return string 'VLML'
     */
    const VALUE_VLML = 'VLML';
    /**
     * Constant for value 'RGML'
     * Meta information extracted from the WSDL
     * - documentation: Designates a regular meal.
     * @return string 'RGML'
     */
    const VALUE_RGML = 'RGML';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVML
     * @uses self::VALUE_BBML
     * @uses self::VALUE_BLML
     * @uses self::VALUE_CHML
     * @uses self::VALUE_DBML
     * @uses self::VALUE_FPML
     * @uses self::VALUE_GFML
     * @uses self::VALUE_HFML
     * @uses self::VALUE_HNML
     * @uses self::VALUE_KSML
     * @uses self::VALUE_LCML
     * @uses self::VALUE_LFML
     * @uses self::VALUE_LPML
     * @uses self::VALUE_LSML
     * @uses self::VALUE_MOML
     * @uses self::VALUE_NLML
     * @uses self::VALUE_ORML
     * @uses self::VALUE_PRML
     * @uses self::VALUE_RVML
     * @uses self::VALUE_SFML
     * @uses self::VALUE_SPML
     * @uses self::VALUE_VGML
     * @uses self::VALUE_VLML
     * @uses self::VALUE_RGML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVML,
            self::VALUE_BBML,
            self::VALUE_BLML,
            self::VALUE_CHML,
            self::VALUE_DBML,
            self::VALUE_FPML,
            self::VALUE_GFML,
            self::VALUE_HFML,
            self::VALUE_HNML,
            self::VALUE_KSML,
            self::VALUE_LCML,
            self::VALUE_LFML,
            self::VALUE_LPML,
            self::VALUE_LSML,
            self::VALUE_MOML,
            self::VALUE_NLML,
            self::VALUE_ORML,
            self::VALUE_PRML,
            self::VALUE_RVML,
            self::VALUE_SFML,
            self::VALUE_SPML,
            self::VALUE_VGML,
            self::VALUE_VLML,
            self::VALUE_RGML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
