<?php

namespace EnumType;

/**
 * This class stands for LocationDetailRequirementAddlDriverInfoType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The LocationDetailRequirementAddlDriverInfoType defines a set of valid values for the textual information about the requirements concerning additional drivers when renting from a rental facility.
 * @subpackage Enumerations
 */
class LocationDetailRequirementAddlDriverInfoType
{
    /**
     * Constant for value 'IncludedAuthorized'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes requirements and restrictions with regard to additional drivers that are automatically authorized as additional drivers of the rented vehicle. The information may provide details on
     * the type of person or relation to the renter that would result in a person being automatically included as an additional driver.
     * @return string 'IncludedAuthorized'
     */
    const VALUE_INCLUDED_AUTHORIZED = 'IncludedAuthorized';
    /**
     * Constant for value 'AdditionalAuthorized'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes requirements and restrictions with regard to others who are not automatically authorized as additional drivers of the rented vehicle. The information may provide details on what
     * should be done to attain such authorization.
     * @return string 'AdditionalAuthorized'
     */
    const VALUE_ADDITIONAL_AUTHORIZED = 'AdditionalAuthorized';
    /**
     * Constant for value 'Fees'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes fees that may be due, based on additional drivers of the rented vehicle.
     * @return string 'Fees'
     */
    const VALUE_FEES = 'Fees';
    /**
     * Constant for value 'Miscellaneous'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes miscellaneous requirements and restrictions with regard to additional drivers of the rented vehicle.
     * @return string 'Miscellaneous'
     */
    const VALUE_MISCELLANEOUS = 'Miscellaneous';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INCLUDED_AUTHORIZED
     * @uses self::VALUE_ADDITIONAL_AUTHORIZED
     * @uses self::VALUE_FEES
     * @uses self::VALUE_MISCELLANEOUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCLUDED_AUTHORIZED,
            self::VALUE_ADDITIONAL_AUTHORIZED,
            self::VALUE_FEES,
            self::VALUE_MISCELLANEOUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
