<?php

namespace EnumType;

/**
 * This class stands for List_SSR_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | An open list of special service request types.
 * @subpackage Enumerations
 */
class List_SSR_Base
{
    /**
     * Constant for value 'BassinetSeatingRequested'
     * @return string 'BassinetSeatingRequested'
     */
    const VALUE_BASSINET_SEATING_REQUESTED = 'BassinetSeatingRequested';
    /**
     * Constant for value 'BlindPassenger'
     * @return string 'BlindPassenger'
     */
    const VALUE_BLIND_PASSENGER = 'BlindPassenger';
    /**
     * Constant for value 'BookingContainsAnInfant'
     * @return string 'BookingContainsAnInfant'
     */
    const VALUE_BOOKING_CONTAINS_AN_INFANT = 'BookingContainsAnInfant';
    /**
     * Constant for value 'BulkheadSeatingRequested'
     * @return string 'BulkheadSeatingRequested'
     */
    const VALUE_BULKHEAD_SEATING_REQUESTED = 'BulkheadSeatingRequested';
    /**
     * Constant for value 'ChildAged2to11Years'
     * @return string 'ChildAged2to11Years'
     */
    const VALUE_CHILD_AGED_2_TO_11_YEARS = 'ChildAged2to11Years';
    /**
     * Constant for value 'DeafPassenger'
     * @return string 'DeafPassenger'
     */
    const VALUE_DEAF_PASSENGER = 'DeafPassenger';
    /**
     * Constant for value 'ExtraSeatRequired'
     * @return string 'ExtraSeatRequired'
     */
    const VALUE_EXTRA_SEAT_REQUIRED = 'ExtraSeatRequired';
    /**
     * Constant for value 'ImpairedMobilityPassenger'
     * @return string 'ImpairedMobilityPassenger'
     */
    const VALUE_IMPAIRED_MOBILITY_PASSENGER = 'ImpairedMobilityPassenger';
    /**
     * Constant for value 'InfantAccompanyingAdultPassenger'
     * @return string 'InfantAccompanyingAdultPassenger'
     */
    const VALUE_INFANT_ACCOMPANYING_ADULT_PASSENGER = 'InfantAccompanyingAdultPassenger';
    /**
     * Constant for value 'LanguageAssistance'
     * @return string 'LanguageAssistance'
     */
    const VALUE_LANGUAGE_ASSISTANCE = 'LanguageAssistance';
    /**
     * Constant for value 'MedicalCondition'
     * @return string 'MedicalCondition'
     */
    const VALUE_MEDICAL_CONDITION = 'MedicalCondition';
    /**
     * Constant for value 'MeetAndAssist'
     * @return string 'MeetAndAssist'
     */
    const VALUE_MEET_AND_ASSIST = 'MeetAndAssist';
    /**
     * Constant for value 'OxygenRequired'
     * @return string 'OxygenRequired'
     */
    const VALUE_OXYGEN_REQUIRED = 'OxygenRequired';
    /**
     * Constant for value 'PetInCabin'
     * @return string 'PetInCabin'
     */
    const VALUE_PET_IN_CABIN = 'PetInCabin';
    /**
     * Constant for value 'SpecialDiet_MealRestrictions'
     * @return string 'SpecialDiet_MealRestrictions'
     */
    const VALUE_SPECIAL_DIET_MEAL_RESTRICTIONS = 'SpecialDiet_MealRestrictions';
    /**
     * Constant for value 'ServiceAnimal'
     * @return string 'ServiceAnimal'
     */
    const VALUE_SERVICE_ANIMAL = 'ServiceAnimal';
    /**
     * Constant for value 'SpecialLuggage'
     * @return string 'SpecialLuggage'
     */
    const VALUE_SPECIAL_LUGGAGE = 'SpecialLuggage';
    /**
     * Constant for value 'UnaccompaniedMinor'
     * @return string 'UnaccompaniedMinor'
     */
    const VALUE_UNACCOMPANIED_MINOR = 'UnaccompaniedMinor';
    /**
     * Constant for value 'WheelchairRequired'
     * @return string 'WheelchairRequired'
     */
    const VALUE_WHEELCHAIR_REQUIRED = 'WheelchairRequired';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASSINET_SEATING_REQUESTED
     * @uses self::VALUE_BLIND_PASSENGER
     * @uses self::VALUE_BOOKING_CONTAINS_AN_INFANT
     * @uses self::VALUE_BULKHEAD_SEATING_REQUESTED
     * @uses self::VALUE_CHILD_AGED_2_TO_11_YEARS
     * @uses self::VALUE_DEAF_PASSENGER
     * @uses self::VALUE_EXTRA_SEAT_REQUIRED
     * @uses self::VALUE_IMPAIRED_MOBILITY_PASSENGER
     * @uses self::VALUE_INFANT_ACCOMPANYING_ADULT_PASSENGER
     * @uses self::VALUE_LANGUAGE_ASSISTANCE
     * @uses self::VALUE_MEDICAL_CONDITION
     * @uses self::VALUE_MEET_AND_ASSIST
     * @uses self::VALUE_OXYGEN_REQUIRED
     * @uses self::VALUE_PET_IN_CABIN
     * @uses self::VALUE_SPECIAL_DIET_MEAL_RESTRICTIONS
     * @uses self::VALUE_SERVICE_ANIMAL
     * @uses self::VALUE_SPECIAL_LUGGAGE
     * @uses self::VALUE_UNACCOMPANIED_MINOR
     * @uses self::VALUE_WHEELCHAIR_REQUIRED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASSINET_SEATING_REQUESTED,
            self::VALUE_BLIND_PASSENGER,
            self::VALUE_BOOKING_CONTAINS_AN_INFANT,
            self::VALUE_BULKHEAD_SEATING_REQUESTED,
            self::VALUE_CHILD_AGED_2_TO_11_YEARS,
            self::VALUE_DEAF_PASSENGER,
            self::VALUE_EXTRA_SEAT_REQUIRED,
            self::VALUE_IMPAIRED_MOBILITY_PASSENGER,
            self::VALUE_INFANT_ACCOMPANYING_ADULT_PASSENGER,
            self::VALUE_LANGUAGE_ASSISTANCE,
            self::VALUE_MEDICAL_CONDITION,
            self::VALUE_MEET_AND_ASSIST,
            self::VALUE_OXYGEN_REQUIRED,
            self::VALUE_PET_IN_CABIN,
            self::VALUE_SPECIAL_DIET_MEAL_RESTRICTIONS,
            self::VALUE_SERVICE_ANIMAL,
            self::VALUE_SPECIAL_LUGGAGE,
            self::VALUE_UNACCOMPANIED_MINOR,
            self::VALUE_WHEELCHAIR_REQUIRED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
