<?php

namespace EnumType;

/**
 * This class stands for List_RecycleFacilityLocation_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of recycling bin/ facility locations.
 * @subpackage Enumerations
 */
class List_RecycleFacilityLocation_Base
{
    /**
     * Constant for value 'CommonAreas'
     * @return string 'CommonAreas'
     */
    const VALUE_COMMON_AREAS = 'CommonAreas';
    /**
     * Constant for value 'Garage'
     * @return string 'Garage'
     */
    const VALUE_GARAGE = 'Garage';
    /**
     * Constant for value 'GuestRoom'
     * @return string 'GuestRoom'
     */
    const VALUE_GUEST_ROOM = 'GuestRoom';
    /**
     * Constant for value 'MeetingRoom'
     * @return string 'MeetingRoom'
     */
    const VALUE_MEETING_ROOM = 'MeetingRoom';
    /**
     * Constant for value 'Restaurant'
     * @return string 'Restaurant'
     */
    const VALUE_RESTAURANT = 'Restaurant';
    /**
     * Constant for value 'StaffArea'
     * @return string 'StaffArea'
     */
    const VALUE_STAFF_AREA = 'StaffArea';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMON_AREAS
     * @uses self::VALUE_GARAGE
     * @uses self::VALUE_GUEST_ROOM
     * @uses self::VALUE_MEETING_ROOM
     * @uses self::VALUE_RESTAURANT
     * @uses self::VALUE_STAFF_AREA
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMON_AREAS,
            self::VALUE_GARAGE,
            self::VALUE_GUEST_ROOM,
            self::VALUE_MEETING_ROOM,
            self::VALUE_RESTAURANT,
            self::VALUE_STAFF_AREA,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
