<?php

namespace EnumType;

/**
 * This class stands for List_RateCategory_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Rate Category (RTC) OpenTravel codelist. | An open list of rate categories.
 * @subpackage Enumerations
 */
class List_RateCategory_Base
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'Association'
     * @return string 'Association'
     */
    const VALUE_ASSOCIATION = 'Association';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'BusinessStandard'
     * @return string 'BusinessStandard'
     */
    const VALUE_BUSINESS_STANDARD = 'BusinessStandard';
    /**
     * Constant for value 'Consortiums'
     * @return string 'Consortiums'
     */
    const VALUE_CONSORTIUMS = 'Consortiums';
    /**
     * Constant for value 'Conventions'
     * @return string 'Conventions'
     */
    const VALUE_CONVENTIONS = 'Conventions';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Constant for value 'Credential'
     * @return string 'Credential'
     */
    const VALUE_CREDENTIAL = 'Credential';
    /**
     * Constant for value 'Employee'
     * @return string 'Employee'
     */
    const VALUE_EMPLOYEE = 'Employee';
    /**
     * Constant for value 'FullyInclusive'
     * @return string 'FullyInclusive'
     */
    const VALUE_FULLY_INCLUSIVE = 'FullyInclusive';
    /**
     * Constant for value 'Government'
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Inclusive'
     * @return string 'Inclusive'
     */
    const VALUE_INCLUSIVE = 'Inclusive';
    /**
     * Constant for value 'Industry'
     * @return string 'Industry'
     */
    const VALUE_INDUSTRY = 'Industry';
    /**
     * Constant for value 'Leisure'
     * @return string 'Leisure'
     */
    const VALUE_LEISURE = 'Leisure';
    /**
     * Constant for value 'Negotiated'
     * @return string 'Negotiated'
     */
    const VALUE_NEGOTIATED = 'Negotiated';
    /**
     * Constant for value 'Promotional'
     * @return string 'Promotional'
     */
    const VALUE_PROMOTIONAL = 'Promotional';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ASSOCIATION
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_BUSINESS_STANDARD
     * @uses self::VALUE_CONSORTIUMS
     * @uses self::VALUE_CONVENTIONS
     * @uses self::VALUE_CORPORATE
     * @uses self::VALUE_CREDENTIAL
     * @uses self::VALUE_EMPLOYEE
     * @uses self::VALUE_FULLY_INCLUSIVE
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_INCLUSIVE
     * @uses self::VALUE_INDUSTRY
     * @uses self::VALUE_LEISURE
     * @uses self::VALUE_NEGOTIATED
     * @uses self::VALUE_PROMOTIONAL
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ASSOCIATION,
            self::VALUE_BUSINESS,
            self::VALUE_BUSINESS_STANDARD,
            self::VALUE_CONSORTIUMS,
            self::VALUE_CONVENTIONS,
            self::VALUE_CORPORATE,
            self::VALUE_CREDENTIAL,
            self::VALUE_EMPLOYEE,
            self::VALUE_FULLY_INCLUSIVE,
            self::VALUE_GOVERNMENT,
            self::VALUE_INCLUSIVE,
            self::VALUE_INDUSTRY,
            self::VALUE_LEISURE,
            self::VALUE_NEGOTIATED,
            self::VALUE_PROMOTIONAL,
            self::VALUE_STANDARD,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
