<?php

namespace EnumType;

/**
 * This class stands for List_QuestionCategory_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: An open list of review question categories.
 * @subpackage Enumerations
 */
class List_QuestionCategory_Base
{
    /**
     * Constant for value 'OverallRating'
     * @return string 'OverallRating'
     */
    const VALUE_OVERALL_RATING = 'OverallRating';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'Accessibility'
     * @return string 'Accessibility'
     */
    const VALUE_ACCESSIBILITY = 'Accessibility';
    /**
     * Constant for value 'Ambiance'
     * @return string 'Ambiance'
     */
    const VALUE_AMBIANCE = 'Ambiance';
    /**
     * Constant for value 'Beach'
     * @return string 'Beach'
     */
    const VALUE_BEACH = 'Beach';
    /**
     * Constant for value 'BedComfort'
     * @return string 'BedComfort'
     */
    const VALUE_BED_COMFORT = 'BedComfort';
    /**
     * Constant for value 'Cleanliness'
     * @return string 'Cleanliness'
     */
    const VALUE_CLEANLINESS = 'Cleanliness';
    /**
     * Constant for value 'Cons'
     * @return string 'Cons'
     */
    const VALUE_CONS = 'Cons';
    /**
     * Constant for value 'FamilyFriendly'
     * @return string 'FamilyFriendly'
     */
    const VALUE_FAMILY_FRIENDLY = 'FamilyFriendly';
    /**
     * Constant for value 'FoodAndBeverage'
     * @return string 'FoodAndBeverage'
     */
    const VALUE_FOOD_AND_BEVERAGE = 'FoodAndBeverage';
    /**
     * Constant for value 'Location'
     * @return string 'Location'
     */
    const VALUE_LOCATION = 'Location';
    /**
     * Constant for value 'Pool'
     * @return string 'Pool'
     */
    const VALUE_POOL = 'Pool';
    /**
     * Constant for value 'Pros'
     * @return string 'Pros'
     */
    const VALUE_PROS = 'Pros';
    /**
     * Constant for value 'RecreationalFacilties'
     * @return string 'RecreationalFacilties'
     */
    const VALUE_RECREATIONAL_FACILTIES = 'RecreationalFacilties';
    /**
     * Constant for value 'Restaurants'
     * @return string 'Restaurants'
     */
    const VALUE_RESTAURANTS = 'Restaurants';
    /**
     * Constant for value 'RoomQuality'
     * @return string 'RoomQuality'
     */
    const VALUE_ROOM_QUALITY = 'RoomQuality';
    /**
     * Constant for value 'Services'
     * @return string 'Services'
     */
    const VALUE_SERVICES = 'Services';
    /**
     * Constant for value 'Staff'
     * @return string 'Staff'
     */
    const VALUE_STAFF = 'Staff';
    /**
     * Constant for value 'Transportation'
     * @return string 'Transportation'
     */
    const VALUE_TRANSPORTATION = 'Transportation';
    /**
     * Constant for value 'TravelerQuestion'
     * @return string 'TravelerQuestion'
     */
    const VALUE_TRAVELER_QUESTION = 'TravelerQuestion';
    /**
     * Constant for value 'TravelerStory'
     * @return string 'TravelerStory'
     */
    const VALUE_TRAVELER_STORY = 'TravelerStory';
    /**
     * Constant for value 'Value'
     * @return string 'Value'
     */
    const VALUE_VALUE = 'Value';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OVERALL_RATING
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ACCESSIBILITY
     * @uses self::VALUE_AMBIANCE
     * @uses self::VALUE_BEACH
     * @uses self::VALUE_BED_COMFORT
     * @uses self::VALUE_CLEANLINESS
     * @uses self::VALUE_CONS
     * @uses self::VALUE_FAMILY_FRIENDLY
     * @uses self::VALUE_FOOD_AND_BEVERAGE
     * @uses self::VALUE_LOCATION
     * @uses self::VALUE_POOL
     * @uses self::VALUE_PROS
     * @uses self::VALUE_RECREATIONAL_FACILTIES
     * @uses self::VALUE_RESTAURANTS
     * @uses self::VALUE_ROOM_QUALITY
     * @uses self::VALUE_SERVICES
     * @uses self::VALUE_STAFF
     * @uses self::VALUE_TRANSPORTATION
     * @uses self::VALUE_TRAVELER_QUESTION
     * @uses self::VALUE_TRAVELER_STORY
     * @uses self::VALUE_VALUE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OVERALL_RATING,
            self::VALUE_ALL,
            self::VALUE_ACCESSIBILITY,
            self::VALUE_AMBIANCE,
            self::VALUE_BEACH,
            self::VALUE_BED_COMFORT,
            self::VALUE_CLEANLINESS,
            self::VALUE_CONS,
            self::VALUE_FAMILY_FRIENDLY,
            self::VALUE_FOOD_AND_BEVERAGE,
            self::VALUE_LOCATION,
            self::VALUE_POOL,
            self::VALUE_PROS,
            self::VALUE_RECREATIONAL_FACILTIES,
            self::VALUE_RESTAURANTS,
            self::VALUE_ROOM_QUALITY,
            self::VALUE_SERVICES,
            self::VALUE_STAFF,
            self::VALUE_TRANSPORTATION,
            self::VALUE_TRAVELER_QUESTION,
            self::VALUE_TRAVELER_STORY,
            self::VALUE_VALUE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
