<?php

namespace EnumType;

/**
 * This class stands for List_OfferWeightUOM EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Unit of Measure (UOM) OpenTravel codelist. | Weight units of measure for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferWeightUOM
{
    /**
     * Constant for value 'Kilogram'
     * @return string 'Kilogram'
     */
    const VALUE_KILOGRAM = 'Kilogram';
    /**
     * Constant for value 'Ounce'
     * @return string 'Ounce'
     */
    const VALUE_OUNCE = 'Ounce';
    /**
     * Constant for value 'Pound'
     * @return string 'Pound'
     */
    const VALUE_POUND = 'Pound';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KILOGRAM
     * @uses self::VALUE_OUNCE
     * @uses self::VALUE_POUND
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KILOGRAM,
            self::VALUE_OUNCE,
            self::VALUE_POUND,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
