<?php

namespace EnumType;

/**
 * This class stands for List_OfferTripStage EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Trip stages for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferTripStage
{
    /**
     * Constant for value 'PreTrip'
     * Meta information extracted from the WSDL
     * - documentation: Passenger is checking in at airport.
     * @return string 'PreTrip'
     */
    const VALUE_PRE_TRIP = 'PreTrip';
    /**
     * Constant for value 'InTrip'
     * Meta information extracted from the WSDL
     * - documentation: The traveler has started, but not completed, this trip mode.
     * @return string 'InTrip'
     */
    const VALUE_IN_TRIP = 'InTrip';
    /**
     * Constant for value 'PostTrip'
     * Meta information extracted from the WSDL
     * - documentation: The traveler has completed the trip mode.
     * @return string 'PostTrip'
     */
    const VALUE_POST_TRIP = 'PostTrip';
    /**
     * Constant for value '_Other'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string '_Other'
     */
    const VALUE_OTHER = '_Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRE_TRIP
     * @uses self::VALUE_IN_TRIP
     * @uses self::VALUE_POST_TRIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRE_TRIP,
            self::VALUE_IN_TRIP,
            self::VALUE_POST_TRIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
