<?php

namespace EnumType;

/**
 * This class stands for List_OfferTripPurpose EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Trip mode purposes for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferTripPurpose
{
    /**
     * Constant for value 'BereavmentOrEmergency'
     * @return string 'BereavmentOrEmergency'
     */
    const VALUE_BEREAVMENT_OR_EMERGENCY = 'BereavmentOrEmergency';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'BusinessAndPersonal'
     * @return string 'BusinessAndPersonal'
     */
    const VALUE_BUSINESS_AND_PERSONAL = 'BusinessAndPersonal';
    /**
     * Constant for value 'CharterOrGroup'
     * @return string 'CharterOrGroup'
     */
    const VALUE_CHARTER_OR_GROUP = 'CharterOrGroup';
    /**
     * Constant for value 'ConferenceOrEvent'
     * @return string 'ConferenceOrEvent'
     */
    const VALUE_CONFERENCE_OR_EVENT = 'ConferenceOrEvent';
    /**
     * Constant for value 'Personal'
     * @return string 'Personal'
     */
    const VALUE_PERSONAL = 'Personal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEREAVMENT_OR_EMERGENCY
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_BUSINESS_AND_PERSONAL
     * @uses self::VALUE_CHARTER_OR_GROUP
     * @uses self::VALUE_CONFERENCE_OR_EVENT
     * @uses self::VALUE_PERSONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEREAVMENT_OR_EMERGENCY,
            self::VALUE_BUSINESS,
            self::VALUE_BUSINESS_AND_PERSONAL,
            self::VALUE_CHARTER_OR_GROUP,
            self::VALUE_CONFERENCE_OR_EVENT,
            self::VALUE_PERSONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
