<?php

namespace EnumType;

/**
 * This class stands for List_OfferTripMode EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Trip modes for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferTripMode
{
    /**
     * Constant for value 'Activity'
     * @return string 'Activity'
     */
    const VALUE_ACTIVITY = 'Activity';
    /**
     * Constant for value 'Flight'
     * @return string 'Flight'
     */
    const VALUE_FLIGHT = 'Flight';
    /**
     * Constant for value 'Cruise'
     * @return string 'Cruise'
     */
    const VALUE_CRUISE = 'Cruise';
    /**
     * Constant for value 'DayTour'
     * @return string 'DayTour'
     */
    const VALUE_DAY_TOUR = 'DayTour';
    /**
     * Constant for value 'GroundTransportation'
     * @return string 'GroundTransportation'
     */
    const VALUE_GROUND_TRANSPORTATION = 'GroundTransportation';
    /**
     * Constant for value 'Lodging'
     * @return string 'Lodging'
     */
    const VALUE_LODGING = 'Lodging';
    /**
     * Constant for value 'PackageTour'
     * @return string 'PackageTour'
     */
    const VALUE_PACKAGE_TOUR = 'PackageTour';
    /**
     * Constant for value 'Train'
     * @return string 'Train'
     */
    const VALUE_TRAIN = 'Train';
    /**
     * Constant for value 'VehicleRental'
     * @return string 'VehicleRental'
     */
    const VALUE_VEHICLE_RENTAL = 'VehicleRental';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVITY
     * @uses self::VALUE_FLIGHT
     * @uses self::VALUE_CRUISE
     * @uses self::VALUE_DAY_TOUR
     * @uses self::VALUE_GROUND_TRANSPORTATION
     * @uses self::VALUE_LODGING
     * @uses self::VALUE_PACKAGE_TOUR
     * @uses self::VALUE_TRAIN
     * @uses self::VALUE_VEHICLE_RENTAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVITY,
            self::VALUE_FLIGHT,
            self::VALUE_CRUISE,
            self::VALUE_DAY_TOUR,
            self::VALUE_GROUND_TRANSPORTATION,
            self::VALUE_LODGING,
            self::VALUE_PACKAGE_TOUR,
            self::VALUE_TRAIN,
            self::VALUE_VEHICLE_RENTAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
