<?php

namespace EnumType;

/**
 * This class stands for List_OfferTravelSegment EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Travel segments for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferTravelSegment
{
    /**
     * Constant for value 'LeisureAndActivities'
     * @return string 'LeisureAndActivities'
     */
    const VALUE_LEISURE_AND_ACTIVITIES = 'LeisureAndActivities';
    /**
     * Constant for value 'Lodging'
     * @return string 'Lodging'
     */
    const VALUE_LODGING = 'Lodging';
    /**
     * Constant for value 'Transportation'
     * @return string 'Transportation'
     */
    const VALUE_TRANSPORTATION = 'Transportation';
    /**
     * Constant for value 'TravelServices'
     * @return string 'TravelServices'
     */
    const VALUE_TRAVEL_SERVICES = 'TravelServices';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEISURE_AND_ACTIVITIES
     * @uses self::VALUE_LODGING
     * @uses self::VALUE_TRANSPORTATION
     * @uses self::VALUE_TRAVEL_SERVICES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEISURE_AND_ACTIVITIES,
            self::VALUE_LODGING,
            self::VALUE_TRANSPORTATION,
            self::VALUE_TRAVEL_SERVICES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
