<?php

namespace EnumType;

/**
 * This class stands for List_OfferTourActivityCategory EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Tour/ activity categories for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferTourActivityCategory
{
    /**
     * Constant for value 'Accessible'
     * @return string 'Accessible'
     */
    const VALUE_ACCESSIBLE = 'Accessible';
    /**
     * Constant for value 'Adventure'
     * @return string 'Adventure'
     */
    const VALUE_ADVENTURE = 'Adventure';
    /**
     * Constant for value 'Cultural'
     * @return string 'Cultural'
     */
    const VALUE_CULTURAL = 'Cultural';
    /**
     * Constant for value 'EcoAdventure'
     * @return string 'EcoAdventure'
     */
    const VALUE_ECO_ADVENTURE = 'EcoAdventure';
    /**
     * Constant for value 'Educational'
     * @return string 'Educational'
     */
    const VALUE_EDUCATIONAL = 'Educational';
    /**
     * Constant for value 'Family'
     * Meta information extracted from the WSDL
     * - documentation: The tour and/or activity content and extertion level are family friendly for children, adults and seniors.
     * @return string 'Family'
     */
    const VALUE_FAMILY = 'Family';
    /**
     * Constant for value 'FoodAndBeverage'
     * @return string 'FoodAndBeverage'
     */
    const VALUE_FOOD_AND_BEVERAGE = 'FoodAndBeverage';
    /**
     * Constant for value 'Group'
     * Meta information extracted from the WSDL
     * - documentation: A day tour or activity that is well-suited for larger parties, e.g. 8+ attendees within a group.
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Romantic'
     * @return string 'Romantic'
     */
    const VALUE_ROMANTIC = 'Romantic';
    /**
     * Constant for value 'SportsAndRecreation'
     * @return string 'SportsAndRecreation'
     */
    const VALUE_SPORTS_AND_RECREATION = 'SportsAndRecreation';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESSIBLE
     * @uses self::VALUE_ADVENTURE
     * @uses self::VALUE_CULTURAL
     * @uses self::VALUE_ECO_ADVENTURE
     * @uses self::VALUE_EDUCATIONAL
     * @uses self::VALUE_FAMILY
     * @uses self::VALUE_FOOD_AND_BEVERAGE
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_ROMANTIC
     * @uses self::VALUE_SPORTS_AND_RECREATION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESSIBLE,
            self::VALUE_ADVENTURE,
            self::VALUE_CULTURAL,
            self::VALUE_ECO_ADVENTURE,
            self::VALUE_EDUCATIONAL,
            self::VALUE_FAMILY,
            self::VALUE_FOOD_AND_BEVERAGE,
            self::VALUE_GROUP,
            self::VALUE_ROMANTIC,
            self::VALUE_SPORTS_AND_RECREATION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
