<?php

namespace EnumType;

/**
 * This class stands for List_OfferPaymentMethod EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Payment methods for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPaymentMethod
{
    /**
     * Constant for value 'BusinessCheck'
     * @return string 'BusinessCheck'
     */
    const VALUE_BUSINESS_CHECK = 'BusinessCheck';
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'CorporateAccount'
     * @return string 'CorporateAccount'
     */
    const VALUE_CORPORATE_ACCOUNT = 'CorporateAccount';
    /**
     * Constant for value 'Coupon'
     * @return string 'Coupon'
     */
    const VALUE_COUPON = 'Coupon';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'DebitCard'
     * @return string 'DebitCard'
     */
    const VALUE_DEBIT_CARD = 'DebitCard';
    /**
     * Constant for value 'DirectBill'
     * @return string 'DirectBill'
     */
    const VALUE_DIRECT_BILL = 'DirectBill';
    /**
     * Constant for value 'InternetAccount'
     * @return string 'InternetAccount'
     */
    const VALUE_INTERNET_ACCOUNT = 'InternetAccount';
    /**
     * Constant for value 'LoyaltyPaymentCard'
     * @return string 'LoyaltyPaymentCard'
     */
    const VALUE_LOYALTY_PAYMENT_CARD = 'LoyaltyPaymentCard';
    /**
     * Constant for value 'LoyaltyRedemption'
     * @return string 'LoyaltyRedemption'
     */
    const VALUE_LOYALTY_REDEMPTION = 'LoyaltyRedemption';
    /**
     * Constant for value 'MobilePayment'
     * @return string 'MobilePayment'
     */
    const VALUE_MOBILE_PAYMENT = 'MobilePayment';
    /**
     * Constant for value 'Ticket'
     * @return string 'Ticket'
     */
    const VALUE_TICKET = 'Ticket';
    /**
     * Constant for value 'Voucher'
     * @return string 'Voucher'
     */
    const VALUE_VOUCHER = 'Voucher';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS_CHECK
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_CORPORATE_ACCOUNT
     * @uses self::VALUE_COUPON
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_DEBIT_CARD
     * @uses self::VALUE_DIRECT_BILL
     * @uses self::VALUE_INTERNET_ACCOUNT
     * @uses self::VALUE_LOYALTY_PAYMENT_CARD
     * @uses self::VALUE_LOYALTY_REDEMPTION
     * @uses self::VALUE_MOBILE_PAYMENT
     * @uses self::VALUE_TICKET
     * @uses self::VALUE_VOUCHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS_CHECK,
            self::VALUE_CASH,
            self::VALUE_CHECK,
            self::VALUE_CORPORATE_ACCOUNT,
            self::VALUE_COUPON,
            self::VALUE_CREDIT_CARD,
            self::VALUE_DEBIT_CARD,
            self::VALUE_DIRECT_BILL,
            self::VALUE_INTERNET_ACCOUNT,
            self::VALUE_LOYALTY_PAYMENT_CARD,
            self::VALUE_LOYALTY_REDEMPTION,
            self::VALUE_MOBILE_PAYMENT,
            self::VALUE_TICKET,
            self::VALUE_VOUCHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
