<?php

namespace EnumType;

/**
 * This class stands for List_OfferPassengerType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Traveler/ customer types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferPassengerType
{
    /**
     * Constant for value 'CorporateEmployee'
     * @return string 'CorporateEmployee'
     */
    const VALUE_CORPORATE_EMPLOYEE = 'CorporateEmployee';
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'FrequentGuest'
     * @return string 'FrequentGuest'
     */
    const VALUE_FREQUENT_GUEST = 'FrequentGuest';
    /**
     * Constant for value 'FrequentTraveler'
     * @return string 'FrequentTraveler'
     */
    const VALUE_FREQUENT_TRAVELER = 'FrequentTraveler';
    /**
     * Constant for value 'Government'
     * @return string 'Government'
     */
    const VALUE_GOVERNMENT = 'Government';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'LoyaltyProgramMember'
     * @return string 'LoyaltyProgramMember'
     */
    const VALUE_LOYALTY_PROGRAM_MEMBER = 'LoyaltyProgramMember';
    /**
     * Constant for value 'MeetingAttendee'
     * @return string 'MeetingAttendee'
     */
    const VALUE_MEETING_ATTENDEE = 'MeetingAttendee';
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'Retired'
     * @return string 'Retired'
     */
    const VALUE_RETIRED = 'Retired';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORPORATE_EMPLOYEE
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_FREQUENT_GUEST
     * @uses self::VALUE_FREQUENT_TRAVELER
     * @uses self::VALUE_GOVERNMENT
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_LOYALTY_PROGRAM_MEMBER
     * @uses self::VALUE_MEETING_ATTENDEE
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_RETIRED
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORPORATE_EMPLOYEE,
            self::VALUE_DISABLED,
            self::VALUE_FREQUENT_GUEST,
            self::VALUE_FREQUENT_TRAVELER,
            self::VALUE_GOVERNMENT,
            self::VALUE_GROUP,
            self::VALUE_LOYALTY_PROGRAM_MEMBER,
            self::VALUE_MEETING_ATTENDEE,
            self::VALUE_MILITARY,
            self::VALUE_RETIRED,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
