<?php

namespace EnumType;

/**
 * This class stands for List_OfferLocationType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Location types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferLocationType
{
    /**
     * Constant for value 'Origin'
     * Meta information extracted from the WSDL
     * - documentation: Trip mode origin or starting location.
     * @return string 'Origin'
     */
    const VALUE_ORIGIN = 'Origin';
    /**
     * Constant for value 'Destination'
     * Meta information extracted from the WSDL
     * - documentation: Trip mode ending or destination location.
     * @return string 'Destination'
     */
    const VALUE_DESTINATION = 'Destination';
    /**
     * Constant for value 'SingleLocation'
     * Meta information extracted from the WSDL
     * - documentation: Trip mode start and end locations are the same.
     * @return string 'SingleLocation'
     */
    const VALUE_SINGLE_LOCATION = 'SingleLocation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGIN
     * @uses self::VALUE_DESTINATION
     * @uses self::VALUE_SINGLE_LOCATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGIN,
            self::VALUE_DESTINATION,
            self::VALUE_SINGLE_LOCATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
