<?php

namespace EnumType;

/**
 * This class stands for List_OfferDimensionUOM EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Unit of Measure (UOM) OpenTravel codelist. | Dimension units of measure for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferDimensionUOM
{
    /**
     * Constant for value 'Centimeter'
     * @return string 'Centimeter'
     */
    const VALUE_CENTIMETER = 'Centimeter';
    /**
     * Constant for value 'Foot/Feet'
     * @return string 'Foot/Feet'
     */
    const VALUE_FOOT_FEET = 'Foot/Feet';
    /**
     * Constant for value 'Inch'
     * @return string 'Inch'
     */
    const VALUE_INCH = 'Inch';
    /**
     * Constant for value 'Metre/Meter'
     * @return string 'Metre/Meter'
     */
    const VALUE_METRE_METER = 'Metre/Meter';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CENTIMETER
     * @uses self::VALUE_FOOT_FEET
     * @uses self::VALUE_INCH
     * @uses self::VALUE_METRE_METER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CENTIMETER,
            self::VALUE_FOOT_FEET,
            self::VALUE_INCH,
            self::VALUE_METRE_METER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
