<?php

namespace EnumType;

/**
 * This class stands for List_OfferCustomerValueBasis EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Coverage Type (COV) OpenTravel codelist. | Customer valuation methods for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferCustomerValueBasis
{
    /**
     * Constant for value 'ClassOfService'
     * Meta information extracted from the WSDL
     * - documentation: Class of service booked by the traveler, e.g. first, business, economy.
     * @return string 'ClassOfService'
     */
    const VALUE_CLASS_OF_SERVICE = 'ClassOfService';
    /**
     * Constant for value 'CorporateClient'
     * Meta information extracted from the WSDL
     * - documentation: Traveler is an employee with a preferred or negotiated rate corporate account.
     * @return string 'CorporateClient'
     */
    const VALUE_CORPORATE_CLIENT = 'CorporateClient';
    /**
     * Constant for value 'FareClass'
     * @return string 'FareClass'
     */
    const VALUE_FARE_CLASS = 'FareClass';
    /**
     * Constant for value 'FrequentGuest'
     * @return string 'FrequentGuest'
     */
    const VALUE_FREQUENT_GUEST = 'FrequentGuest';
    /**
     * Constant for value 'FrequentTraveler'
     * @return string 'FrequentTraveler'
     */
    const VALUE_FREQUENT_TRAVELER = 'FrequentTraveler';
    /**
     * Constant for value 'LoyaltyMemberTimePeriod'
     * @return string 'LoyaltyMemberTimePeriod'
     */
    const VALUE_LOYALTY_MEMBER_TIME_PERIOD = 'LoyaltyMemberTimePeriod';
    /**
     * Constant for value 'LoyaltyProgramLevel'
     * @return string 'LoyaltyProgramLevel'
     */
    const VALUE_LOYALTY_PROGRAM_LEVEL = 'LoyaltyProgramLevel';
    /**
     * Constant for value 'PreferredClient'
     * @return string 'PreferredClient'
     */
    const VALUE_PREFERRED_CLIENT = 'PreferredClient';
    /**
     * Constant for value 'PremiumOfferPurchase'
     * @return string 'PremiumOfferPurchase'
     */
    const VALUE_PREMIUM_OFFER_PURCHASE = 'PremiumOfferPurchase';
    /**
     * Constant for value 'TripPrice'
     * @return string 'TripPrice'
     */
    const VALUE_TRIP_PRICE = 'TripPrice';
    /**
     * Constant for value 'TripPurpose'
     * @return string 'TripPurpose'
     */
    const VALUE_TRIP_PURPOSE = 'TripPurpose';
    /**
     * Constant for value 'UpgradePurchased'
     * @return string 'UpgradePurchased'
     */
    const VALUE_UPGRADE_PURCHASED = 'UpgradePurchased';
    /**
     * Constant for value 'VIP'
     * @return string 'VIP'
     */
    const VALUE_VIP = 'VIP';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLASS_OF_SERVICE
     * @uses self::VALUE_CORPORATE_CLIENT
     * @uses self::VALUE_FARE_CLASS
     * @uses self::VALUE_FREQUENT_GUEST
     * @uses self::VALUE_FREQUENT_TRAVELER
     * @uses self::VALUE_LOYALTY_MEMBER_TIME_PERIOD
     * @uses self::VALUE_LOYALTY_PROGRAM_LEVEL
     * @uses self::VALUE_PREFERRED_CLIENT
     * @uses self::VALUE_PREMIUM_OFFER_PURCHASE
     * @uses self::VALUE_TRIP_PRICE
     * @uses self::VALUE_TRIP_PURPOSE
     * @uses self::VALUE_UPGRADE_PURCHASED
     * @uses self::VALUE_VIP
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLASS_OF_SERVICE,
            self::VALUE_CORPORATE_CLIENT,
            self::VALUE_FARE_CLASS,
            self::VALUE_FREQUENT_GUEST,
            self::VALUE_FREQUENT_TRAVELER,
            self::VALUE_LOYALTY_MEMBER_TIME_PERIOD,
            self::VALUE_LOYALTY_PROGRAM_LEVEL,
            self::VALUE_PREFERRED_CLIENT,
            self::VALUE_PREMIUM_OFFER_PURCHASE,
            self::VALUE_TRIP_PRICE,
            self::VALUE_TRIP_PURPOSE,
            self::VALUE_UPGRADE_PURCHASED,
            self::VALUE_VIP,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
