<?php

namespace EnumType;

/**
 * This class stands for List_OfferBookingMethod EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | Booking method types for targeted offers.
 * @subpackage Enumerations
 */
class List_OfferBookingMethod
{
    /**
     * Constant for value 'CorporateTravelPlanner'
     * @return string 'CorporateTravelPlanner'
     */
    const VALUE_CORPORATE_TRAVEL_PLANNER = 'CorporateTravelPlanner';
    /**
     * Constant for value 'Online'
     * @return string 'Online'
     */
    const VALUE_ONLINE = 'Online';
    /**
     * Constant for value 'TravelAgency'
     * @return string 'TravelAgency'
     */
    const VALUE_TRAVEL_AGENCY = 'TravelAgency';
    /**
     * Constant for value 'TravelAgent'
     * @return string 'TravelAgent'
     */
    const VALUE_TRAVEL_AGENT = 'TravelAgent';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @OtherType attribute to exchange a literal that is not in the list and is known to
     * your trading partners.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORPORATE_TRAVEL_PLANNER
     * @uses self::VALUE_ONLINE
     * @uses self::VALUE_TRAVEL_AGENCY
     * @uses self::VALUE_TRAVEL_AGENT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORPORATE_TRAVEL_PLANNER,
            self::VALUE_ONLINE,
            self::VALUE_TRAVEL_AGENCY,
            self::VALUE_TRAVEL_AGENT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
