<?php

namespace EnumType;

/**
 * This class stands for List_GroundServiceProvided_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of ground transportation service types.
 * @subpackage Enumerations
 */
class List_GroundServiceProvided_Base
{
    /**
     * Constant for value 'AirportTransfer'
     * @return string 'AirportTransfer'
     */
    const VALUE_AIRPORT_TRANSFER = 'AirportTransfer';
    /**
     * Constant for value 'SharedTransportation'
     * @return string 'SharedTransportation'
     */
    const VALUE_SHARED_TRANSPORTATION = 'SharedTransportation';
    /**
     * Constant for value 'Hourly'
     * @return string 'Hourly'
     */
    const VALUE_HOURLY = 'Hourly';
    /**
     * Constant for value 'Mileage'
     * @return string 'Mileage'
     */
    const VALUE_MILEAGE = 'Mileage';
    /**
     * Constant for value 'SimpleTransfer'
     * @return string 'SimpleTransfer'
     */
    const VALUE_SIMPLE_TRANSFER = 'SimpleTransfer';
    /**
     * Constant for value 'Shuttle'
     * @return string 'Shuttle'
     */
    const VALUE_SHUTTLE = 'Shuttle';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT_TRANSFER
     * @uses self::VALUE_SHARED_TRANSPORTATION
     * @uses self::VALUE_HOURLY
     * @uses self::VALUE_MILEAGE
     * @uses self::VALUE_SIMPLE_TRANSFER
     * @uses self::VALUE_SHUTTLE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT_TRANSFER,
            self::VALUE_SHARED_TRANSPORTATION,
            self::VALUE_HOURLY,
            self::VALUE_MILEAGE,
            self::VALUE_SIMPLE_TRANSFER,
            self::VALUE_SHUTTLE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
