<?php

namespace EnumType;

/**
 * This class stands for List_GroundLocationType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of location types for ground transportation service.
 * @subpackage Enumerations
 */
class List_GroundLocationType_Base
{
    /**
     * Constant for value 'Airport'
     * @return string 'Airport'
     */
    const VALUE_AIRPORT = 'Airport';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'Company'
     * @return string 'Company'
     */
    const VALUE_COMPANY = 'Company';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'PointOfInterest'
     * @return string 'PointOfInterest'
     */
    const VALUE_POINT_OF_INTEREST = 'PointOfInterest';
    /**
     * Constant for value 'Port'
     * @return string 'Port'
     */
    const VALUE_PORT = 'Port';
    /**
     * Constant for value 'Region'
     * @return string 'Region'
     */
    const VALUE_REGION = 'Region';
    /**
     * Constant for value 'HomeResidence'
     * @return string 'HomeResidence'
     */
    const VALUE_HOME_RESIDENCE = 'HomeResidence';
    /**
     * Constant for value 'TrainStation'
     * @return string 'TrainStation'
     */
    const VALUE_TRAIN_STATION = 'TrainStation';
    /**
     * Constant for value 'Vicinity'
     * @return string 'Vicinity'
     */
    const VALUE_VICINITY = 'Vicinity';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_CITY
     * @uses self::VALUE_COMPANY
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_POINT_OF_INTEREST
     * @uses self::VALUE_PORT
     * @uses self::VALUE_REGION
     * @uses self::VALUE_HOME_RESIDENCE
     * @uses self::VALUE_TRAIN_STATION
     * @uses self::VALUE_VICINITY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT,
            self::VALUE_CITY,
            self::VALUE_COMPANY,
            self::VALUE_HOTEL,
            self::VALUE_POINT_OF_INTEREST,
            self::VALUE_PORT,
            self::VALUE_REGION,
            self::VALUE_HOME_RESIDENCE,
            self::VALUE_TRAIN_STATION,
            self::VALUE_VICINITY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
