<?php

namespace EnumType;

/**
 * This class stands for List_GlobalIndicatorType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel. | An open list of global travel areas.
 * @subpackage Enumerations
 */
class List_GlobalIndicatorType_Base
{
    /**
     * Constant for value 'AP'
     * Meta information extracted from the WSDL
     * - documentation: Atlantic/Pacific Round-the-World
     * @return string 'AP'
     */
    const VALUE_AP = 'AP';
    /**
     * Constant for value 'AT'
     * Meta information extracted from the WSDL
     * - documentation: Atlantic Ocean
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'CT'
     * Meta information extracted from the WSDL
     * - documentation: Circle trip
     * @return string 'CT'
     */
    const VALUE_CT = 'CT';
    /**
     * Constant for value 'DO'
     * Meta information extracted from the WSDL
     * - documentation: Domestic
     * @return string 'DO'
     */
    const VALUE_DO = 'DO';
    /**
     * Constant for value 'EH'
     * Meta information extracted from the WSDL
     * - documentation: Eastern Hemisphere
     * @return string 'EH'
     */
    const VALUE_EH = 'EH';
    /**
     * Constant for value 'FE'
     * Meta information extracted from the WSDL
     * - documentation: Within the Far East
     * @return string 'FE'
     */
    const VALUE_FE = 'FE';
    /**
     * Constant for value 'PA'
     * Meta information extracted from the WSDL
     * - documentation: Pacific Ocean
     * @return string 'PA'
     */
    const VALUE_PA = 'PA';
    /**
     * Constant for value 'PN'
     * Meta information extracted from the WSDL
     * - documentation: TC1-TC3 via Pacific/N. America
     * @return string 'PN'
     */
    const VALUE_PN = 'PN';
    /**
     * Constant for value 'PO'
     * Meta information extracted from the WSDL
     * - documentation: Polar Route
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'RU'
     * Meta information extracted from the WSDL
     * - documentation: Russia Area 3
     * @return string 'RU'
     */
    const VALUE_RU = 'RU';
    /**
     * Constant for value 'RW'
     * Meta information extracted from the WSDL
     * - documentation: Round the world
     * @return string 'RW'
     */
    const VALUE_RW = 'RW';
    /**
     * Constant for value 'SA'
     * Meta information extracted from the WSDL
     * - documentation: South Atlantic only
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'TS'
     * Meta information extracted from the WSDL
     * - documentation: Trans Siberia Route
     * @return string 'TS'
     */
    const VALUE_TS = 'TS';
    /**
     * Constant for value 'WH'
     * Meta information extracted from the WSDL
     * - documentation: Western Hemisphere
     * @return string 'WH'
     */
    const VALUE_WH = 'WH';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AP
     * @uses self::VALUE_AT
     * @uses self::VALUE_CT
     * @uses self::VALUE_DO
     * @uses self::VALUE_EH
     * @uses self::VALUE_FE
     * @uses self::VALUE_PA
     * @uses self::VALUE_PN
     * @uses self::VALUE_PO
     * @uses self::VALUE_RU
     * @uses self::VALUE_RW
     * @uses self::VALUE_SA
     * @uses self::VALUE_TS
     * @uses self::VALUE_WH
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AP,
            self::VALUE_AT,
            self::VALUE_CT,
            self::VALUE_DO,
            self::VALUE_EH,
            self::VALUE_FE,
            self::VALUE_PA,
            self::VALUE_PN,
            self::VALUE_PO,
            self::VALUE_RU,
            self::VALUE_RW,
            self::VALUE_SA,
            self::VALUE_TS,
            self::VALUE_WH,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
