<?php

namespace EnumType;

/**
 * This class stands for List_FeeTaxType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Fee Tax Type (FTT) OpenTravel codelist. | An open list of fee or tax types.
 * @subpackage Enumerations
 */
class List_FeeTaxType_Base
{
    /**
     * Constant for value 'AdultRollawayFee'
     * @return string 'AdultRollawayFee'
     */
    const VALUE_ADULT_ROLLAWAY_FEE = 'AdultRollawayFee';
    /**
     * Constant for value 'ApplicationFee'
     * @return string 'ApplicationFee'
     */
    const VALUE_APPLICATION_FEE = 'ApplicationFee';
    /**
     * Constant for value 'Assessment/LicenseTax'
     * @return string 'Assessment/LicenseTax'
     */
    const VALUE_ASSESSMENT_LICENSE_TAX = 'Assessment/LicenseTax';
    /**
     * Constant for value 'BanquetServiceFee'
     * @return string 'BanquetServiceFee'
     */
    const VALUE_BANQUET_SERVICE_FEE = 'BanquetServiceFee';
    /**
     * Constant for value 'BedTax'
     * @return string 'BedTax'
     */
    const VALUE_BED_TAX = 'BedTax';
    /**
     * Constant for value 'ChildRollawayCharge'
     * @return string 'ChildRollawayCharge'
     */
    const VALUE_CHILD_ROLLAWAY_CHARGE = 'ChildRollawayCharge';
    /**
     * Constant for value 'CityHotelFee'
     * @return string 'CityHotelFee'
     */
    const VALUE_CITY_HOTEL_FEE = 'CityHotelFee';
    /**
     * Constant for value 'CityTax'
     * @return string 'CityTax'
     */
    const VALUE_CITY_TAX = 'CityTax';
    /**
     * Constant for value 'ConventionTax'
     * @return string 'ConventionTax'
     */
    const VALUE_CONVENTION_TAX = 'ConventionTax';
    /**
     * Constant for value 'CountryTax'
     * @return string 'CountryTax'
     */
    const VALUE_COUNTRY_TAX = 'CountryTax';
    /**
     * Constant for value 'CountyTax'
     * @return string 'CountyTax'
     */
    const VALUE_COUNTY_TAX = 'CountyTax';
    /**
     * Constant for value 'CribFee'
     * @return string 'CribFee'
     */
    const VALUE_CRIB_FEE = 'CribFee';
    /**
     * Constant for value 'EarlyCheckoutFee'
     * @return string 'EarlyCheckoutFee'
     */
    const VALUE_EARLY_CHECKOUT_FEE = 'EarlyCheckoutFee';
    /**
     * Constant for value 'EnergyTax'
     * @return string 'EnergyTax'
     */
    const VALUE_ENERGY_TAX = 'EnergyTax';
    /**
     * Constant for value 'Exempt'
     * @return string 'Exempt'
     */
    const VALUE_EXEMPT = 'Exempt';
    /**
     * Constant for value 'ExpressHandlingFee'
     * @return string 'ExpressHandlingFee'
     */
    const VALUE_EXPRESS_HANDLING_FEE = 'ExpressHandlingFee';
    /**
     * Constant for value 'ExtraChildCharge'
     * @return string 'ExtraChildCharge'
     */
    const VALUE_EXTRA_CHILD_CHARGE = 'ExtraChildCharge';
    /**
     * Constant for value 'ExtraPersonCharge'
     * @return string 'ExtraPersonCharge'
     */
    const VALUE_EXTRA_PERSON_CHARGE = 'ExtraPersonCharge';
    /**
     * Constant for value 'FederalTax'
     * @return string 'FederalTax'
     */
    const VALUE_FEDERAL_TAX = 'FederalTax';
    /**
     * Constant for value 'FoodAndBeverageTax'
     * @return string 'FoodAndBeverageTax'
     */
    const VALUE_FOOD_AND_BEVERAGE_TAX = 'FoodAndBeverageTax';
    /**
     * Constant for value 'FoodAndBeverageGratuity'
     * @return string 'FoodAndBeverageGratuity'
     */
    const VALUE_FOOD_AND_BEVERAGE_GRATUITY = 'FoodAndBeverageGratuity';
    /**
     * Constant for value 'GoodsAndServicesTax(GST)'
     * @return string 'GoodsAndServicesTax(GST)'
     */
    const VALUE_GOODS_AND_SERVICES_TAX_GST = 'GoodsAndServicesTax(GST)';
    /**
     * Constant for value 'InsurancePremiumTax'
     * @return string 'InsurancePremiumTax'
     */
    const VALUE_INSURANCE_PREMIUM_TAX = 'InsurancePremiumTax';
    /**
     * Constant for value 'LocalFee'
     * @return string 'LocalFee'
     */
    const VALUE_LOCAL_FEE = 'LocalFee';
    /**
     * Constant for value 'LodgingTax'
     * @return string 'LodgingTax'
     */
    const VALUE_LODGING_TAX = 'LodgingTax';
    /**
     * Constant for value 'MaintenanceFee'
     * @return string 'MaintenanceFee'
     */
    const VALUE_MAINTENANCE_FEE = 'MaintenanceFee';
    /**
     * Constant for value 'Miscellaneous'
     * @return string 'Miscellaneous'
     */
    const VALUE_MISCELLANEOUS = 'Miscellaneous';
    /**
     * Constant for value 'NationalGovernmentTax'
     * @return string 'NationalGovernmentTax'
     */
    const VALUE_NATIONAL_GOVERNMENT_TAX = 'NationalGovernmentTax';
    /**
     * Constant for value 'NotKnown'
     * @return string 'NotKnown'
     */
    const VALUE_NOT_KNOWN = 'NotKnown';
    /**
     * Constant for value 'OccupancyTax'
     * @return string 'OccupancyTax'
     */
    const VALUE_OCCUPANCY_TAX = 'OccupancyTax';
    /**
     * Constant for value 'PackageFee'
     * @return string 'PackageFee'
     */
    const VALUE_PACKAGE_FEE = 'PackageFee';
    /**
     * Constant for value 'PetSanitationFee'
     * @return string 'PetSanitationFee'
     */
    const VALUE_PET_SANITATION_FEE = 'PetSanitationFee';
    /**
     * Constant for value 'ResortFee'
     * @return string 'ResortFee'
     */
    const VALUE_RESORT_FEE = 'ResortFee';
    /**
     * Constant for value 'RollawayFee'
     * @return string 'RollawayFee'
     */
    const VALUE_ROLLAWAY_FEE = 'RollawayFee';
    /**
     * Constant for value 'RoomServiceFee'
     * @return string 'RoomServiceFee'
     */
    const VALUE_ROOM_SERVICE_FEE = 'RoomServiceFee';
    /**
     * Constant for value 'RoomTax'
     * @return string 'RoomTax'
     */
    const VALUE_ROOM_TAX = 'RoomTax';
    /**
     * Constant for value 'SalesTax'
     * @return string 'SalesTax'
     */
    const VALUE_SALES_TAX = 'SalesTax';
    /**
     * Constant for value 'ServiceCharge'
     * @return string 'ServiceCharge'
     */
    const VALUE_SERVICE_CHARGE = 'ServiceCharge';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'StateTax'
     * @return string 'StateTax'
     */
    const VALUE_STATE_TAX = 'StateTax';
    /**
     * Constant for value 'Surcharge'
     * @return string 'Surcharge'
     */
    const VALUE_SURCHARGE = 'Surcharge';
    /**
     * Constant for value 'SurplusLinesTax'
     * @return string 'SurplusLinesTax'
     */
    const VALUE_SURPLUS_LINES_TAX = 'SurplusLinesTax';
    /**
     * Constant for value 'TotalTax'
     * @return string 'TotalTax'
     */
    const VALUE_TOTAL_TAX = 'TotalTax';
    /**
     * Constant for value 'TourismTax'
     * @return string 'TourismTax'
     */
    const VALUE_TOURISM_TAX = 'TourismTax';
    /**
     * Constant for value 'ValueAddedTax(VAT)'
     * @return string 'ValueAddedTax(VAT)'
     */
    const VALUE_VALUE_ADDED_TAX_VAT = 'ValueAddedTax(VAT)';
    /**
     * Constant for value 'VAT/GSTTax'
     * @return string 'VAT/GSTTax'
     */
    const VALUE_VAT_GSTTAX = 'VAT/GSTTax';
    /**
     * Constant for value 'Zero-Rated'
     * @return string 'Zero-Rated'
     */
    const VALUE_ZERO_RATED = 'Zero-Rated';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADULT_ROLLAWAY_FEE
     * @uses self::VALUE_APPLICATION_FEE
     * @uses self::VALUE_ASSESSMENT_LICENSE_TAX
     * @uses self::VALUE_BANQUET_SERVICE_FEE
     * @uses self::VALUE_BED_TAX
     * @uses self::VALUE_CHILD_ROLLAWAY_CHARGE
     * @uses self::VALUE_CITY_HOTEL_FEE
     * @uses self::VALUE_CITY_TAX
     * @uses self::VALUE_CONVENTION_TAX
     * @uses self::VALUE_COUNTRY_TAX
     * @uses self::VALUE_COUNTY_TAX
     * @uses self::VALUE_CRIB_FEE
     * @uses self::VALUE_EARLY_CHECKOUT_FEE
     * @uses self::VALUE_ENERGY_TAX
     * @uses self::VALUE_EXEMPT
     * @uses self::VALUE_EXPRESS_HANDLING_FEE
     * @uses self::VALUE_EXTRA_CHILD_CHARGE
     * @uses self::VALUE_EXTRA_PERSON_CHARGE
     * @uses self::VALUE_FEDERAL_TAX
     * @uses self::VALUE_FOOD_AND_BEVERAGE_TAX
     * @uses self::VALUE_FOOD_AND_BEVERAGE_GRATUITY
     * @uses self::VALUE_GOODS_AND_SERVICES_TAX_GST
     * @uses self::VALUE_INSURANCE_PREMIUM_TAX
     * @uses self::VALUE_LOCAL_FEE
     * @uses self::VALUE_LODGING_TAX
     * @uses self::VALUE_MAINTENANCE_FEE
     * @uses self::VALUE_MISCELLANEOUS
     * @uses self::VALUE_NATIONAL_GOVERNMENT_TAX
     * @uses self::VALUE_NOT_KNOWN
     * @uses self::VALUE_OCCUPANCY_TAX
     * @uses self::VALUE_PACKAGE_FEE
     * @uses self::VALUE_PET_SANITATION_FEE
     * @uses self::VALUE_RESORT_FEE
     * @uses self::VALUE_ROLLAWAY_FEE
     * @uses self::VALUE_ROOM_SERVICE_FEE
     * @uses self::VALUE_ROOM_TAX
     * @uses self::VALUE_SALES_TAX
     * @uses self::VALUE_SERVICE_CHARGE
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_STATE_TAX
     * @uses self::VALUE_SURCHARGE
     * @uses self::VALUE_SURPLUS_LINES_TAX
     * @uses self::VALUE_TOTAL_TAX
     * @uses self::VALUE_TOURISM_TAX
     * @uses self::VALUE_VALUE_ADDED_TAX_VAT
     * @uses self::VALUE_VAT_GSTTAX
     * @uses self::VALUE_ZERO_RATED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADULT_ROLLAWAY_FEE,
            self::VALUE_APPLICATION_FEE,
            self::VALUE_ASSESSMENT_LICENSE_TAX,
            self::VALUE_BANQUET_SERVICE_FEE,
            self::VALUE_BED_TAX,
            self::VALUE_CHILD_ROLLAWAY_CHARGE,
            self::VALUE_CITY_HOTEL_FEE,
            self::VALUE_CITY_TAX,
            self::VALUE_CONVENTION_TAX,
            self::VALUE_COUNTRY_TAX,
            self::VALUE_COUNTY_TAX,
            self::VALUE_CRIB_FEE,
            self::VALUE_EARLY_CHECKOUT_FEE,
            self::VALUE_ENERGY_TAX,
            self::VALUE_EXEMPT,
            self::VALUE_EXPRESS_HANDLING_FEE,
            self::VALUE_EXTRA_CHILD_CHARGE,
            self::VALUE_EXTRA_PERSON_CHARGE,
            self::VALUE_FEDERAL_TAX,
            self::VALUE_FOOD_AND_BEVERAGE_TAX,
            self::VALUE_FOOD_AND_BEVERAGE_GRATUITY,
            self::VALUE_GOODS_AND_SERVICES_TAX_GST,
            self::VALUE_INSURANCE_PREMIUM_TAX,
            self::VALUE_LOCAL_FEE,
            self::VALUE_LODGING_TAX,
            self::VALUE_MAINTENANCE_FEE,
            self::VALUE_MISCELLANEOUS,
            self::VALUE_NATIONAL_GOVERNMENT_TAX,
            self::VALUE_NOT_KNOWN,
            self::VALUE_OCCUPANCY_TAX,
            self::VALUE_PACKAGE_FEE,
            self::VALUE_PET_SANITATION_FEE,
            self::VALUE_RESORT_FEE,
            self::VALUE_ROLLAWAY_FEE,
            self::VALUE_ROOM_SERVICE_FEE,
            self::VALUE_ROOM_TAX,
            self::VALUE_SALES_TAX,
            self::VALUE_SERVICE_CHARGE,
            self::VALUE_STANDARD,
            self::VALUE_STATE_TAX,
            self::VALUE_SURCHARGE,
            self::VALUE_SURPLUS_LINES_TAX,
            self::VALUE_TOTAL_TAX,
            self::VALUE_TOURISM_TAX,
            self::VALUE_VALUE_ADDED_TAX_VAT,
            self::VALUE_VAT_GSTTAX,
            self::VALUE_ZERO_RATED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
