<?php

namespace EnumType;

/**
 * This class stands for List_BankAccountType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | An open list of bank account types.
 * @subpackage Enumerations
 */
class List_BankAccountType_Base
{
    /**
     * Constant for value 'Checking'
     * @return string 'Checking'
     */
    const VALUE_CHECKING = 'Checking';
    /**
     * Constant for value 'Investment'
     * @return string 'Investment'
     */
    const VALUE_INVESTMENT = 'Investment';
    /**
     * Constant for value 'Savings'
     * @return string 'Savings'
     */
    const VALUE_SAVINGS = 'Savings';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECKING
     * @uses self::VALUE_INVESTMENT
     * @uses self::VALUE_SAVINGS
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECKING,
            self::VALUE_INVESTMENT,
            self::VALUE_SAVINGS,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
