<?php

namespace EnumType;

/**
 * This class stands for List_ApplyToLevel_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Age Qualifying Code (AQC) OpenTravel codelist filtered. | An open list of levels that a code item applies to.
 * @subpackage Enumerations
 */
class List_ApplyToLevel_Base
{
    /**
     * Constant for value 'Cabin'
     * Meta information extracted from the WSDL
     * - documentation: An airplane, train or ship cabin.
     * @return string 'Cabin'
     */
    const VALUE_CABIN = 'Cabin';
    /**
     * Constant for value 'Facility'
     * Meta information extracted from the WSDL
     * - documentation: An on or offsite facility, such as a restaurant or car rental location.
     * @return string 'Facility'
     */
    const VALUE_FACILITY = 'Facility';
    /**
     * Constant for value 'GuestRoom'
     * Meta information extracted from the WSDL
     * - documentation: A guest room.
     * @return string 'GuestRoom'
     */
    const VALUE_GUEST_ROOM = 'GuestRoom';
    /**
     * Constant for value 'MeetingRoom'
     * Meta information extracted from the WSDL
     * - documentation: A meeting room.
     * @return string 'MeetingRoom'
     */
    const VALUE_MEETING_ROOM = 'MeetingRoom';
    /**
     * Constant for value 'Property'
     * Meta information extracted from the WSDL
     * - documentation: A property, such as a hotel or vacation rental unit.
     * @return string 'Property'
     */
    const VALUE_PROPERTY = 'Property';
    /**
     * Constant for value 'Seat'
     * Meta information extracted from the WSDL
     * - documentation: A seat, such as an airplane or train seat.
     * @return string 'Seat'
     */
    const VALUE_SEAT = 'Seat';
    /**
     * Constant for value 'Ship'
     * Meta information extracted from the WSDL
     * - documentation: A cruise ship.
     * @return string 'Ship'
     */
    const VALUE_SHIP = 'Ship';
    /**
     * Constant for value 'Unit'
     * Meta information extracted from the WSDL
     * - documentation: A vacation rental unit.
     * @return string 'Unit'
     */
    const VALUE_UNIT = 'Unit';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CABIN
     * @uses self::VALUE_FACILITY
     * @uses self::VALUE_GUEST_ROOM
     * @uses self::VALUE_MEETING_ROOM
     * @uses self::VALUE_PROPERTY
     * @uses self::VALUE_SEAT
     * @uses self::VALUE_SHIP
     * @uses self::VALUE_UNIT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CABIN,
            self::VALUE_FACILITY,
            self::VALUE_GUEST_ROOM,
            self::VALUE_MEETING_ROOM,
            self::VALUE_PROPERTY,
            self::VALUE_SEAT,
            self::VALUE_SHIP,
            self::VALUE_UNIT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
