<?php

namespace EnumType;

/**
 * This class stands for List_AirFareDateType_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: OpenTravel | An open list of air fare applicable date types.
 * @subpackage Enumerations
 */
class List_AirFareDateType_Base
{
    /**
     * Constant for value 'DiscontinueTravel'
     * Meta information extracted from the WSDL
     * - documentation: The last travel date for this fare.
     * @return string 'DiscontinueTravel'
     */
    const VALUE_DISCONTINUE_TRAVEL = 'DiscontinueTravel';
    /**
     * Constant for value 'EffectiveTravel'
     * Meta information extracted from the WSDL
     * - documentation: The first travel date for this fare.
     * @return string 'EffectiveTravel'
     */
    const VALUE_EFFECTIVE_TRAVEL = 'EffectiveTravel';
    /**
     * Constant for value 'FirstTicketing'
     * Meta information extracted from the WSDL
     * - documentation: The first date for ticketing.
     * @return string 'FirstTicketing'
     */
    const VALUE_FIRST_TICKETING = 'FirstTicketing';
    /**
     * Constant for value 'Historic'
     * @return string 'Historic'
     */
    const VALUE_HISTORIC = 'Historic';
    /**
     * Constant for value 'LastTicketing'
     * Meta information extracted from the WSDL
     * - documentation: The last date for ticketing.
     * @return string 'LastTicketing'
     */
    const VALUE_LAST_TICKETING = 'LastTicketing';
    /**
     * Constant for value 'TravelCompletion'
     * Meta information extracted from the WSDL
     * - documentation: The date by which travel must be completed.
     * @return string 'TravelCompletion'
     */
    const VALUE_TRAVEL_COMPLETION = 'TravelCompletion';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISCONTINUE_TRAVEL
     * @uses self::VALUE_EFFECTIVE_TRAVEL
     * @uses self::VALUE_FIRST_TICKETING
     * @uses self::VALUE_HISTORIC
     * @uses self::VALUE_LAST_TICKETING
     * @uses self::VALUE_TRAVEL_COMPLETION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISCONTINUE_TRAVEL,
            self::VALUE_EFFECTIVE_TRAVEL,
            self::VALUE_FIRST_TICKETING,
            self::VALUE_HISTORIC,
            self::VALUE_LAST_TICKETING,
            self::VALUE_TRAVEL_COMPLETION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
