<?php

namespace EnumType;

/**
 * This class stands for List_AgeCategory_Base EnumType
 * Meta information extracted from the WSDL
 * - documentation: Source: Age Qualifying Code (AQC) OpenTravel codelist filtered. | An open list of person age categories.
 * @subpackage Enumerations
 */
class List_AgeCategory_Base
{
    /**
     * Constant for value 'Adult'
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Child'
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Infant'
     * @return string 'Infant'
     */
    const VALUE_INFANT = 'Infant';
    /**
     * Constant for value 'Junior'
     * @return string 'Junior'
     */
    const VALUE_JUNIOR = 'Junior';
    /**
     * Constant for value 'Over21'
     * @return string 'Over21'
     */
    const VALUE_OVER_21 = 'Over21';
    /**
     * Constant for value 'Over65'
     * @return string 'Over65'
     */
    const VALUE_OVER_65 = 'Over65';
    /**
     * Constant for value 'Senior'
     * @return string 'Senior'
     */
    const VALUE_SENIOR = 'Senior';
    /**
     * Constant for value 'Student'
     * @return string 'Student'
     */
    const VALUE_STUDENT = 'Student';
    /**
     * Constant for value 'Teenager'
     * @return string 'Teenager'
     */
    const VALUE_TEENAGER = 'Teenager';
    /**
     * Constant for value 'Under10'
     * @return string 'Under10'
     */
    const VALUE_UNDER_10 = 'Under10';
    /**
     * Constant for value 'Under12'
     * @return string 'Under12'
     */
    const VALUE_UNDER_12 = 'Under12';
    /**
     * Constant for value 'Under17'
     * @return string 'Under17'
     */
    const VALUE_UNDER_17 = 'Under17';
    /**
     * Constant for value 'Under2'
     * @return string 'Under2'
     */
    const VALUE_UNDER_2 = 'Under2';
    /**
     * Constant for value 'Under21'
     * @return string 'Under21'
     */
    const VALUE_UNDER_21 = 'Under21';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use: Select this enumeration to exchange a value that is not in the enumerated list by entering the value information in the Code Extension fields.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_INFANT
     * @uses self::VALUE_JUNIOR
     * @uses self::VALUE_OVER_21
     * @uses self::VALUE_OVER_65
     * @uses self::VALUE_SENIOR
     * @uses self::VALUE_STUDENT
     * @uses self::VALUE_TEENAGER
     * @uses self::VALUE_UNDER_10
     * @uses self::VALUE_UNDER_12
     * @uses self::VALUE_UNDER_17
     * @uses self::VALUE_UNDER_2
     * @uses self::VALUE_UNDER_21
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_INFANT,
            self::VALUE_JUNIOR,
            self::VALUE_OVER_21,
            self::VALUE_OVER_65,
            self::VALUE_SENIOR,
            self::VALUE_STUDENT,
            self::VALUE_TEENAGER,
            self::VALUE_UNDER_10,
            self::VALUE_UNDER_12,
            self::VALUE_UNDER_17,
            self::VALUE_UNDER_2,
            self::VALUE_UNDER_21,
            self::VALUE_UNKNOWN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
