<?php

namespace EnumType;

/**
 * This class stands for GuaranteeType EnumType
 * @subpackage Enumerations
 */
class GuaranteeType
{
    /**
     * Constant for value 'PrePay'
     * @return string 'PrePay'
     */
    const VALUE_PRE_PAY = 'PrePay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRE_PAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRE_PAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
