<?php

namespace EnumType;

/**
 * This class stands for FareAmountType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify if ticket amount is bulk, IT, or NOADC.
 * @subpackage Enumerations
 */
class FareAmountType
{
    /**
     * Constant for value 'NOADC'
     * @return string 'NOADC'
     */
    const VALUE_NOADC = 'NOADC';
    /**
     * Constant for value 'Bulk'
     * @return string 'Bulk'
     */
    const VALUE_BULK = 'Bulk';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'Additional_Collection'
     * Meta information extracted from the WSDL
     * - documentation: This amount represents an additional collection.
     * @return string 'Additional_Collection'
     */
    const VALUE_ADDITIONAL_COLLECTION = 'Additional_Collection';
    /**
     * Constant for value 'Charter_Fare'
     * Meta information extracted from the WSDL
     * - documentation: This amount represents a fare for a charter flight.
     * @return string 'Charter_Fare'
     */
    const VALUE_CHARTER_FARE = 'Charter_Fare';
    /**
     * Constant for value 'No_Fare'
     * Meta information extracted from the WSDL
     * - documentation: No fare applies.
     * @return string 'No_Fare'
     */
    const VALUE_NO_FARE = 'No_Fare';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOADC
     * @uses self::VALUE_BULK
     * @uses self::VALUE_IT
     * @uses self::VALUE_ADDITIONAL_COLLECTION
     * @uses self::VALUE_CHARTER_FARE
     * @uses self::VALUE_NO_FARE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOADC,
            self::VALUE_BULK,
            self::VALUE_IT,
            self::VALUE_ADDITIONAL_COLLECTION,
            self::VALUE_CHARTER_FARE,
            self::VALUE_NO_FARE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
