<?php

namespace EnumType;

/**
 * This class stands for Enum_UniqueIDType EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of unique ID types.
 * @subpackage Enumerations
 */
class Enum_UniqueIDType
{
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'CRO_CustomerReservationsOffice'
     * @return string 'CRO_CustomerReservationsOffice'
     */
    const VALUE_CRO_CUSTOMER_RESERVATIONS_OFFICE = 'CRO_CustomerReservationsOffice';
    /**
     * Constant for value 'CorporationRepresentative'
     * @return string 'CorporationRepresentative'
     */
    const VALUE_CORPORATION_REPRESENTATIVE = 'CorporationRepresentative';
    /**
     * Constant for value 'Company'
     * @return string 'Company'
     */
    const VALUE_COMPANY = 'Company';
    /**
     * Constant for value 'TravelAgency'
     * @return string 'TravelAgency'
     */
    const VALUE_TRAVEL_AGENCY = 'TravelAgency';
    /**
     * Constant for value 'Airline'
     * @return string 'Airline'
     */
    const VALUE_AIRLINE = 'Airline';
    /**
     * Constant for value 'Wholesaler'
     * @return string 'Wholesaler'
     */
    const VALUE_WHOLESALER = 'Wholesaler';
    /**
     * Constant for value 'CarRental'
     * @return string 'CarRental'
     */
    const VALUE_CAR_RENTAL = 'CarRental';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'TourOperator'
     * @return string 'TourOperator'
     */
    const VALUE_TOUR_OPERATOR = 'TourOperator';
    /**
     * Constant for value 'CruiseLine'
     * @return string 'CruiseLine'
     */
    const VALUE_CRUISE_LINE = 'CruiseLine';
    /**
     * Constant for value 'InternetBroker'
     * @return string 'InternetBroker'
     */
    const VALUE_INTERNET_BROKER = 'InternetBroker';
    /**
     * Constant for value 'Reservation'
     * @return string 'Reservation'
     */
    const VALUE_RESERVATION = 'Reservation';
    /**
     * Constant for value 'Cancellation'
     * @return string 'Cancellation'
     */
    const VALUE_CANCELLATION = 'Cancellation';
    /**
     * Constant for value 'Reference'
     * @return string 'Reference'
     */
    const VALUE_REFERENCE = 'Reference';
    /**
     * Constant for value 'MeetingPlanningAgency'
     * @return string 'MeetingPlanningAgency'
     */
    const VALUE_MEETING_PLANNING_AGENCY = 'MeetingPlanningAgency';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'InsuranceAgency'
     * @return string 'InsuranceAgency'
     */
    const VALUE_INSURANCE_AGENCY = 'InsuranceAgency';
    /**
     * Constant for value 'InsuranceAgent'
     * @return string 'InsuranceAgent'
     */
    const VALUE_INSURANCE_AGENT = 'InsuranceAgent';
    /**
     * Constant for value 'Profile'
     * @return string 'Profile'
     */
    const VALUE_PROFILE = 'Profile';
    /**
     * Constant for value 'ERSP_ElectronicReservationServiceProvider) '
     * @return string 'ERSP_ElectronicReservationServiceProvider) '
     */
    const VALUE_ERSP_ELECTRONIC_RESERVATION_SERVICE_PROVIDER = 'ERSP_ElectronicReservationServiceProvider) ';
    /**
     * Constant for value 'ProvisionalReservation'
     * @return string 'ProvisionalReservation'
     */
    const VALUE_PROVISIONAL_RESERVATION = 'ProvisionalReservation';
    /**
     * Constant for value 'TravelAgentPNR'
     * @return string 'TravelAgentPNR'
     */
    const VALUE_TRAVEL_AGENT_PNR = 'TravelAgentPNR';
    /**
     * Constant for value 'AssociatedReservation'
     * @return string 'AssociatedReservation'
     */
    const VALUE_ASSOCIATED_RESERVATION = 'AssociatedReservation';
    /**
     * Constant for value 'AssociatedItineraryReservation'
     * @return string 'AssociatedItineraryReservation'
     */
    const VALUE_ASSOCIATED_ITINERARY_RESERVATION = 'AssociatedItineraryReservation';
    /**
     * Constant for value 'AssociatedSharedReservation'
     * @return string 'AssociatedSharedReservation'
     */
    const VALUE_ASSOCIATED_SHARED_RESERVATION = 'AssociatedSharedReservation';
    /**
     * Constant for value 'Alliance'
     * @return string 'Alliance'
     */
    const VALUE_ALLIANCE = 'Alliance';
    /**
     * Constant for value 'BookingAgent'
     * @return string 'BookingAgent'
     */
    const VALUE_BOOKING_AGENT = 'BookingAgent';
    /**
     * Constant for value 'Ticket'
     * @return string 'Ticket'
     */
    const VALUE_TICKET = 'Ticket';
    /**
     * Constant for value 'DividedReservation'
     * @return string 'DividedReservation'
     */
    const VALUE_DIVIDED_RESERVATION = 'DividedReservation';
    /**
     * Constant for value 'Merchant'
     * @return string 'Merchant'
     */
    const VALUE_MERCHANT = 'Merchant';
    /**
     * Constant for value 'Acquirer'
     * @return string 'Acquirer'
     */
    const VALUE_ACQUIRER = 'Acquirer';
    /**
     * Constant for value 'MasterReference'
     * @return string 'MasterReference'
     */
    const VALUE_MASTER_REFERENCE = 'MasterReference';
    /**
     * Constant for value 'PurgedMasterReference'
     * @return string 'PurgedMasterReference'
     */
    const VALUE_PURGED_MASTER_REFERENCE = 'PurgedMasterReference';
    /**
     * Constant for value 'ParentReference'
     * @return string 'ParentReference'
     */
    const VALUE_PARENT_REFERENCE = 'ParentReference';
    /**
     * Constant for value 'ChildReference'
     * @return string 'ChildReference'
     */
    const VALUE_CHILD_REFERENCE = 'ChildReference';
    /**
     * Constant for value 'LinkedReference'
     * @return string 'LinkedReference'
     */
    const VALUE_LINKED_REFERENCE = 'LinkedReference';
    /**
     * Constant for value 'Contract'
     * @return string 'Contract'
     */
    const VALUE_CONTRACT = 'Contract';
    /**
     * Constant for value 'ConfirmationNumber'
     * @return string 'ConfirmationNumber'
     */
    const VALUE_CONFIRMATION_NUMBER = 'ConfirmationNumber';
    /**
     * Constant for value 'FareQuote'
     * @return string 'FareQuote'
     */
    const VALUE_FARE_QUOTE = 'FareQuote';
    /**
     * Constant for value 'ReissueRefundQuote'
     * @return string 'ReissueRefundQuote'
     */
    const VALUE_REISSUE_REFUND_QUOTE = 'ReissueRefundQuote';
    /**
     * Constant for value 'GroundTransportationSupplier'
     * @return string 'GroundTransportationSupplier'
     */
    const VALUE_GROUND_TRANSPORTATION_SUPPLIER = 'GroundTransportationSupplier';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER_1 = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_CRO_CUSTOMER_RESERVATIONS_OFFICE
     * @uses self::VALUE_CORPORATION_REPRESENTATIVE
     * @uses self::VALUE_COMPANY
     * @uses self::VALUE_TRAVEL_AGENCY
     * @uses self::VALUE_AIRLINE
     * @uses self::VALUE_WHOLESALER
     * @uses self::VALUE_CAR_RENTAL
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_TOUR_OPERATOR
     * @uses self::VALUE_CRUISE_LINE
     * @uses self::VALUE_INTERNET_BROKER
     * @uses self::VALUE_RESERVATION
     * @uses self::VALUE_CANCELLATION
     * @uses self::VALUE_REFERENCE
     * @uses self::VALUE_MEETING_PLANNING_AGENCY
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_INSURANCE_AGENCY
     * @uses self::VALUE_INSURANCE_AGENT
     * @uses self::VALUE_PROFILE
     * @uses self::VALUE_ERSP_ELECTRONIC_RESERVATION_SERVICE_PROVIDER
     * @uses self::VALUE_PROVISIONAL_RESERVATION
     * @uses self::VALUE_TRAVEL_AGENT_PNR
     * @uses self::VALUE_ASSOCIATED_RESERVATION
     * @uses self::VALUE_ASSOCIATED_ITINERARY_RESERVATION
     * @uses self::VALUE_ASSOCIATED_SHARED_RESERVATION
     * @uses self::VALUE_ALLIANCE
     * @uses self::VALUE_BOOKING_AGENT
     * @uses self::VALUE_TICKET
     * @uses self::VALUE_DIVIDED_RESERVATION
     * @uses self::VALUE_MERCHANT
     * @uses self::VALUE_ACQUIRER
     * @uses self::VALUE_MASTER_REFERENCE
     * @uses self::VALUE_PURGED_MASTER_REFERENCE
     * @uses self::VALUE_PARENT_REFERENCE
     * @uses self::VALUE_CHILD_REFERENCE
     * @uses self::VALUE_LINKED_REFERENCE
     * @uses self::VALUE_CONTRACT
     * @uses self::VALUE_CONFIRMATION_NUMBER
     * @uses self::VALUE_FARE_QUOTE
     * @uses self::VALUE_REISSUE_REFUND_QUOTE
     * @uses self::VALUE_GROUND_TRANSPORTATION_SUPPLIER
     * @uses self::VALUE_OTHER_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUSTOMER,
            self::VALUE_CRO_CUSTOMER_RESERVATIONS_OFFICE,
            self::VALUE_CORPORATION_REPRESENTATIVE,
            self::VALUE_COMPANY,
            self::VALUE_TRAVEL_AGENCY,
            self::VALUE_AIRLINE,
            self::VALUE_WHOLESALER,
            self::VALUE_CAR_RENTAL,
            self::VALUE_GROUP,
            self::VALUE_HOTEL,
            self::VALUE_TOUR_OPERATOR,
            self::VALUE_CRUISE_LINE,
            self::VALUE_INTERNET_BROKER,
            self::VALUE_RESERVATION,
            self::VALUE_CANCELLATION,
            self::VALUE_REFERENCE,
            self::VALUE_MEETING_PLANNING_AGENCY,
            self::VALUE_OTHER,
            self::VALUE_INSURANCE_AGENCY,
            self::VALUE_INSURANCE_AGENT,
            self::VALUE_PROFILE,
            self::VALUE_ERSP_ELECTRONIC_RESERVATION_SERVICE_PROVIDER,
            self::VALUE_PROVISIONAL_RESERVATION,
            self::VALUE_TRAVEL_AGENT_PNR,
            self::VALUE_ASSOCIATED_RESERVATION,
            self::VALUE_ASSOCIATED_ITINERARY_RESERVATION,
            self::VALUE_ASSOCIATED_SHARED_RESERVATION,
            self::VALUE_ALLIANCE,
            self::VALUE_BOOKING_AGENT,
            self::VALUE_TICKET,
            self::VALUE_DIVIDED_RESERVATION,
            self::VALUE_MERCHANT,
            self::VALUE_ACQUIRER,
            self::VALUE_MASTER_REFERENCE,
            self::VALUE_PURGED_MASTER_REFERENCE,
            self::VALUE_PARENT_REFERENCE,
            self::VALUE_CHILD_REFERENCE,
            self::VALUE_LINKED_REFERENCE,
            self::VALUE_CONTRACT,
            self::VALUE_CONFIRMATION_NUMBER,
            self::VALUE_FARE_QUOTE,
            self::VALUE_REISSUE_REFUND_QUOTE,
            self::VALUE_GROUND_TRANSPORTATION_SUPPLIER,
            self::VALUE_OTHER_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
