<?php

namespace EnumType;

/**
 * This class stands for Enum_SeatRowCharacteristics EnumType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of seat row characteristics.
 * @subpackage Enumerations
 */
class Enum_SeatRowCharacteristics
{
    /**
     * Constant for value 'BufferRow'
     * @return string 'BufferRow'
     */
    const VALUE_BUFFER_ROW = 'BufferRow';
    /**
     * Constant for value 'ExitLeft'
     * @return string 'ExitLeft'
     */
    const VALUE_EXIT_LEFT = 'ExitLeft';
    /**
     * Constant for value 'ExitRight'
     * @return string 'ExitRight'
     */
    const VALUE_EXIT_RIGHT = 'ExitRight';
    /**
     * Constant for value 'ExitRow'
     * @return string 'ExitRow'
     */
    const VALUE_EXIT_ROW = 'ExitRow';
    /**
     * Constant for value 'ExitRowWithCabinFacilitiesInDesignatedColumn'
     * @return string 'ExitRowWithCabinFacilitiesInDesignatedColumn'
     */
    const VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN = 'ExitRowWithCabinFacilitiesInDesignatedColumn';
    /**
     * Constant for value 'ExitRowWithCabinFacilitiesInUndesignatedColumn'
     * @return string 'ExitRowWithCabinFacilitiesInUndesignatedColumn'
     */
    const VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN = 'ExitRowWithCabinFacilitiesInUndesignatedColumn';
    /**
     * Constant for value 'ExtraLegRoom'
     * @return string 'ExtraLegRoom'
     */
    const VALUE_EXTRA_LEG_ROOM = 'ExtraLegRoom';
    /**
     * Constant for value 'IndifferentRow'
     * @return string 'IndifferentRow'
     */
    const VALUE_INDIFFERENT_ROW = 'IndifferentRow';
    /**
     * Constant for value 'LowerdeckRow'
     * @return string 'LowerdeckRow'
     */
    const VALUE_LOWERDECK_ROW = 'LowerdeckRow';
    /**
     * Constant for value 'MaindeckRow'
     * @return string 'MaindeckRow'
     */
    const VALUE_MAINDECK_ROW = 'MaindeckRow';
    /**
     * Constant for value 'NosmokingRow'
     * @return string 'NosmokingRow'
     */
    const VALUE_NOSMOKING_ROW = 'NosmokingRow';
    /**
     * Constant for value 'NotOverwingRow'
     * @return string 'NotOverwingRow'
     */
    const VALUE_NOT_OVERWING_ROW = 'NotOverwingRow';
    /**
     * Constant for value 'OverwingRow'
     * @return string 'OverwingRow'
     */
    const VALUE_OVERWING_ROW = 'OverwingRow';
    /**
     * Constant for value 'RowDoesNotExist'
     * @return string 'RowDoesNotExist'
     */
    const VALUE_ROW_DOES_NOT_EXIST = 'RowDoesNotExist';
    /**
     * Constant for value 'RowWithCabinFacilitiesInDesignatedColumn'
     * @return string 'RowWithCabinFacilitiesInDesignatedColumn'
     */
    const VALUE_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN = 'RowWithCabinFacilitiesInDesignatedColumn';
    /**
     * Constant for value 'RowWithCabinFacilitiesInUndesignatedColumn'
     * @return string 'RowWithCabinFacilitiesInUndesignatedColumn'
     */
    const VALUE_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN = 'RowWithCabinFacilitiesInUndesignatedColumn';
    /**
     * Constant for value 'RowWithMovieScreen'
     * @return string 'RowWithMovieScreen'
     */
    const VALUE_ROW_WITH_MOVIE_SCREEN = 'RowWithMovieScreen';
    /**
     * Constant for value 'SeatRestrictionsApply'
     * @return string 'SeatRestrictionsApply'
     */
    const VALUE_SEAT_RESTRICTIONS_APPLY = 'SeatRestrictionsApply';
    /**
     * Constant for value 'SmokingRow'
     * @return string 'SmokingRow'
     */
    const VALUE_SMOKING_ROW = 'SmokingRow';
    /**
     * Constant for value 'UpperDeckRow'
     * @return string 'UpperDeckRow'
     */
    const VALUE_UPPER_DECK_ROW = 'UpperDeckRow';
    /**
     * Constant for value 'Preferred_PreferentialRow'
     * @return string 'Preferred_PreferentialRow'
     */
    const VALUE_PREFERRED_PREFERENTIAL_ROW = 'Preferred_PreferentialRow';
    /**
     * Constant for value 'WingStart'
     * @return string 'WingStart'
     */
    const VALUE_WING_START = 'WingStart';
    /**
     * Constant for value 'WingEnd'
     * @return string 'WingEnd'
     */
    const VALUE_WING_END = 'WingEnd';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: Use this value to provide an extended enumeration that is not in the provided list. | It is strongly recommended that you submit a comment to have any of your extended list values permanently added to the OpenTravel specification to
     * support maximum trading partner interoperability. http://www.opentraveldevelopersnetwork.com/specificationcomments/2/entercomment.html
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUFFER_ROW
     * @uses self::VALUE_EXIT_LEFT
     * @uses self::VALUE_EXIT_RIGHT
     * @uses self::VALUE_EXIT_ROW
     * @uses self::VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN
     * @uses self::VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN
     * @uses self::VALUE_EXTRA_LEG_ROOM
     * @uses self::VALUE_INDIFFERENT_ROW
     * @uses self::VALUE_LOWERDECK_ROW
     * @uses self::VALUE_MAINDECK_ROW
     * @uses self::VALUE_NOSMOKING_ROW
     * @uses self::VALUE_NOT_OVERWING_ROW
     * @uses self::VALUE_OVERWING_ROW
     * @uses self::VALUE_ROW_DOES_NOT_EXIST
     * @uses self::VALUE_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN
     * @uses self::VALUE_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN
     * @uses self::VALUE_ROW_WITH_MOVIE_SCREEN
     * @uses self::VALUE_SEAT_RESTRICTIONS_APPLY
     * @uses self::VALUE_SMOKING_ROW
     * @uses self::VALUE_UPPER_DECK_ROW
     * @uses self::VALUE_PREFERRED_PREFERENTIAL_ROW
     * @uses self::VALUE_WING_START
     * @uses self::VALUE_WING_END
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUFFER_ROW,
            self::VALUE_EXIT_LEFT,
            self::VALUE_EXIT_RIGHT,
            self::VALUE_EXIT_ROW,
            self::VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN,
            self::VALUE_EXIT_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN,
            self::VALUE_EXTRA_LEG_ROOM,
            self::VALUE_INDIFFERENT_ROW,
            self::VALUE_LOWERDECK_ROW,
            self::VALUE_MAINDECK_ROW,
            self::VALUE_NOSMOKING_ROW,
            self::VALUE_NOT_OVERWING_ROW,
            self::VALUE_OVERWING_ROW,
            self::VALUE_ROW_DOES_NOT_EXIST,
            self::VALUE_ROW_WITH_CABIN_FACILITIES_IN_DESIGNATED_COLUMN,
            self::VALUE_ROW_WITH_CABIN_FACILITIES_IN_UNDESIGNATED_COLUMN,
            self::VALUE_ROW_WITH_MOVIE_SCREEN,
            self::VALUE_SEAT_RESTRICTIONS_APPLY,
            self::VALUE_SMOKING_ROW,
            self::VALUE_UPPER_DECK_ROW,
            self::VALUE_PREFERRED_PREFERENTIAL_ROW,
            self::VALUE_WING_START,
            self::VALUE_WING_END,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
