<?php

namespace EnumType;

/**
 * This class stands for DeckType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the train deck, such as lower level and upper level.
 * @subpackage Enumerations
 */
class DeckType
{
    /**
     * Constant for value 'Regular-OneLevelOnly'
     * @return string 'Regular-OneLevelOnly'
     */
    const VALUE_REGULAR_ONE_LEVEL_ONLY = 'Regular-OneLevelOnly';
    /**
     * Constant for value 'LowerLevel'
     * @return string 'LowerLevel'
     */
    const VALUE_LOWER_LEVEL = 'LowerLevel';
    /**
     * Constant for value 'UpperLevel'
     * @return string 'UpperLevel'
     */
    const VALUE_UPPER_LEVEL = 'UpperLevel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR_ONE_LEVEL_ONLY
     * @uses self::VALUE_LOWER_LEVEL
     * @uses self::VALUE_UPPER_LEVEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR_ONE_LEVEL_ONLY,
            self::VALUE_LOWER_LEVEL,
            self::VALUE_UPPER_LEVEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
