<?php

namespace EnumType;

/**
 * This class stands for CompartmentTypeEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Rail compartment types with an "Other" value to support an open enumeration list as agreed upon between trading partners.
 * @subpackage Enumerations
 */
class CompartmentTypeEnum
{
    /**
     * Constant for value 'NotSignificant'
     * @return string 'NotSignificant'
     */
    const VALUE_NOT_SIGNIFICANT = 'NotSignificant';
    /**
     * Constant for value 'Family'
     * @return string 'Family'
     */
    const VALUE_FAMILY = 'Family';
    /**
     * Constant for value 'Quite'
     * @return string 'Quite'
     */
    const VALUE_QUITE = 'Quite';
    /**
     * Constant for value 'Conference'
     * @return string 'Conference'
     */
    const VALUE_CONFERENCE = 'Conference';
    /**
     * Constant for value 'CompartmentWithoutAnimals'
     * Meta information extracted from the WSDL
     * - documentation: Compartment without animals
     * @return string 'CompartmentWithoutAnimals'
     */
    const VALUE_COMPARTMENT_WITHOUT_ANIMALS = 'CompartmentWithoutAnimals';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'Video'
     * Meta information extracted from the WSDL
     * - documentation: Video compartment
     * @return string 'Video'
     */
    const VALUE_VIDEO = 'Video';
    /**
     * Constant for value 'Pram'
     * @return string 'Pram'
     */
    const VALUE_PRAM = 'Pram';
    /**
     * Constant for value 'WomanAndChild'
     * Meta information extracted from the WSDL
     * - documentation: Woman and Child compartment
     * @return string 'WomanAndChild'
     */
    const VALUE_WOMAN_AND_CHILD = 'WomanAndChild';
    /**
     * Constant for value 'EasyAccess'
     * Meta information extracted from the WSDL
     * - documentation: Placess with easy access - PRMS
     * @return string 'EasyAccess'
     */
    const VALUE_EASY_ACCESS = 'EasyAccess';
    /**
     * Constant for value 'T2'
     * Meta information extracted from the WSDL
     * - documentation: Two-berth compartment
     * @return string 'T2'
     */
    const VALUE_T_2 = 'T2';
    /**
     * Constant for value 'T3'
     * Meta information extracted from the WSDL
     * - documentation: Three-berth compartment
     * @return string 'T3'
     */
    const VALUE_T_3 = 'T3';
    /**
     * Constant for value 'T4'
     * Meta information extracted from the WSDL
     * - documentation: Four-berth compartment
     * @return string 'T4'
     */
    const VALUE_T_4 = 'T4';
    /**
     * Constant for value 'T6'
     * Meta information extracted from the WSDL
     * - documentation: Six-berth compartment
     * @return string 'T6'
     */
    const VALUE_T_6 = 'T6';
    /**
     * Constant for value 'C2'
     * Meta information extracted from the WSDL
     * - documentation: compartment with 2 couchettes
     * @return string 'C2'
     */
    const VALUE_C_2 = 'C2';
    /**
     * Constant for value 'C4'
     * Meta information extracted from the WSDL
     * - documentation: compartment with 4 couchettes
     * @return string 'C4'
     */
    const VALUE_C_4 = 'C4';
    /**
     * Constant for value 'C5'
     * Meta information extracted from the WSDL
     * - documentation: compartment with 5 couchettes
     * @return string 'C5'
     */
    const VALUE_C_5 = 'C5';
    /**
     * Constant for value 'C6'
     * Meta information extracted from the WSDL
     * - documentation: compartment with 6 couchettes
     * @return string 'C6'
     */
    const VALUE_C_6 = 'C6';
    /**
     * Constant for value 'Single'
     * Meta information extracted from the WSDL
     * - documentation: Single-berth compartment
     * @return string 'Single'
     */
    const VALUE_SINGLE = 'Single';
    /**
     * Constant for value 'Double'
     * Meta information extracted from the WSDL
     * - documentation: Double-berth compartment
     * @return string 'Double'
     */
    const VALUE_DOUBLE = 'Double';
    /**
     * Constant for value 'SingleSuite'
     * Meta information extracted from the WSDL
     * - documentation: Single suite compartment
     * @return string 'SingleSuite'
     */
    const VALUE_SINGLE_SUITE = 'SingleSuite';
    /**
     * Constant for value 'DoubleSuite'
     * Meta information extracted from the WSDL
     * - documentation: Double suite compartment
     * @return string 'DoubleSuite'
     */
    const VALUE_DOUBLE_SUITE = 'DoubleSuite';
    /**
     * Constant for value 'Special'
     * Meta information extracted from the WSDL
     * - documentation: Special-berth compartment
     * @return string 'Special'
     */
    const VALUE_SPECIAL = 'Special';
    /**
     * Constant for value 'Other_'
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Reserved words, "Other_" as enumerated value for open enumeration support to support additional compartment type. The Value corresponding to "Other_" will be specified in the "Value" attribute. See CompartmentType.
     * @return string 'Other_'
     */
    const VALUE_OTHER = 'Other_';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SIGNIFICANT
     * @uses self::VALUE_FAMILY
     * @uses self::VALUE_QUITE
     * @uses self::VALUE_CONFERENCE
     * @uses self::VALUE_COMPARTMENT_WITHOUT_ANIMALS
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_PRAM
     * @uses self::VALUE_WOMAN_AND_CHILD
     * @uses self::VALUE_EASY_ACCESS
     * @uses self::VALUE_T_2
     * @uses self::VALUE_T_3
     * @uses self::VALUE_T_4
     * @uses self::VALUE_T_6
     * @uses self::VALUE_C_2
     * @uses self::VALUE_C_4
     * @uses self::VALUE_C_5
     * @uses self::VALUE_C_6
     * @uses self::VALUE_SINGLE
     * @uses self::VALUE_DOUBLE
     * @uses self::VALUE_SINGLE_SUITE
     * @uses self::VALUE_DOUBLE_SUITE
     * @uses self::VALUE_SPECIAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SIGNIFICANT,
            self::VALUE_FAMILY,
            self::VALUE_QUITE,
            self::VALUE_CONFERENCE,
            self::VALUE_COMPARTMENT_WITHOUT_ANIMALS,
            self::VALUE_COMPLETE,
            self::VALUE_VIDEO,
            self::VALUE_PRAM,
            self::VALUE_WOMAN_AND_CHILD,
            self::VALUE_EASY_ACCESS,
            self::VALUE_T_2,
            self::VALUE_T_3,
            self::VALUE_T_4,
            self::VALUE_T_6,
            self::VALUE_C_2,
            self::VALUE_C_4,
            self::VALUE_C_5,
            self::VALUE_C_6,
            self::VALUE_SINGLE,
            self::VALUE_DOUBLE,
            self::VALUE_SINGLE_SUITE,
            self::VALUE_DOUBLE_SUITE,
            self::VALUE_SPECIAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
