<?php

namespace EnumType;

/**
 * This class stands for CompartmentPositionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the position of a compartment, such as upper and lower.
 * @subpackage Enumerations
 */
class CompartmentPositionType
{
    /**
     * Constant for value 'CloseToRestaurantCar'
     * @return string 'CloseToRestaurantCar'
     */
    const VALUE_CLOSE_TO_RESTAURANT_CAR = 'CloseToRestaurantCar';
    /**
     * Constant for value 'CloseToExit'
     * @return string 'CloseToExit'
     */
    const VALUE_CLOSE_TO_EXIT = 'CloseToExit';
    /**
     * Constant for value 'CloseToToilet'
     * @return string 'CloseToToilet'
     */
    const VALUE_CLOSE_TO_TOILET = 'CloseToToilet';
    /**
     * Constant for value 'MiddleOfCar'
     * @return string 'MiddleOfCar'
     */
    const VALUE_MIDDLE_OF_CAR = 'MiddleOfCar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSE_TO_RESTAURANT_CAR
     * @uses self::VALUE_CLOSE_TO_EXIT
     * @uses self::VALUE_CLOSE_TO_TOILET
     * @uses self::VALUE_MIDDLE_OF_CAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSE_TO_RESTAURANT_CAR,
            self::VALUE_CLOSE_TO_EXIT,
            self::VALUE_CLOSE_TO_TOILET,
            self::VALUE_MIDDLE_OF_CAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
