<?php

namespace EnumType;

/**
 * This class stands for CommissionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Indicates whether the Rate is a percentage (P) or a value (V).
 * @subpackage Enumerations
 */
class CommissionType
{
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Constant for value 'Value'
     * @return string 'Value'
     */
    const VALUE_VALUE = 'Value';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERCENTAGE
     * @uses self::VALUE_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERCENTAGE,
            self::VALUE_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
