<?php

namespace EnumType;

/**
 * This class stands for BerthPositionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the position of a berth, e.g. upper, lower, middle.
 * @subpackage Enumerations
 */
class BerthPositionType
{
    /**
     * Constant for value 'Upper'
     * @return string 'Upper'
     */
    const VALUE_UPPER = 'Upper';
    /**
     * Constant for value 'Middle'
     * @return string 'Middle'
     */
    const VALUE_MIDDLE = 'Middle';
    /**
     * Constant for value 'Lower'
     * @return string 'Lower'
     */
    const VALUE_LOWER = 'Lower';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPPER
     * @uses self::VALUE_MIDDLE
     * @uses self::VALUE_LOWER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPPER,
            self::VALUE_MIDDLE,
            self::VALUE_LOWER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
