<?php

namespace EnumType;

/**
 * This class stands for BerthAccommodationType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the type of berth accommodation, such as couchette and sleeper.
 * @subpackage Enumerations
 */
class BerthAccommodationType
{
    /**
     * Constant for value 'NotSignificant'
     * @return string 'NotSignificant'
     */
    const VALUE_NOT_SIGNIFICANT = 'NotSignificant';
    /**
     * Constant for value 'Berth'
     * @return string 'Berth'
     */
    const VALUE_BERTH = 'Berth';
    /**
     * Constant for value 'Couchette'
     * @return string 'Couchette'
     */
    const VALUE_COUCHETTE = 'Couchette';
    /**
     * Constant for value 'Sleeper'
     * @return string 'Sleeper'
     */
    const VALUE_SLEEPER = 'Sleeper';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SIGNIFICANT
     * @uses self::VALUE_BERTH
     * @uses self::VALUE_COUCHETTE
     * @uses self::VALUE_SLEEPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SIGNIFICANT,
            self::VALUE_BERTH,
            self::VALUE_COUCHETTE,
            self::VALUE_SLEEPER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
